package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodDisruptionBudgetSpecFluent<A extends PodDisruptionBudgetSpecFluent<A>> extends BaseFluent<A>{
  public PodDisruptionBudgetSpecFluent() {
  }
  public PodDisruptionBudgetSpecFluent(PodDisruptionBudgetSpec instance) {
    instance = (instance != null ? instance : new PodDisruptionBudgetSpec());

    if (instance != null) {
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withMinAvailable(instance.getMinAvailable());
      this.withSelector(instance.getSelector());
      this.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withMinAvailable(instance.getMinAvailable());
      this.withSelector(instance.getSelector());
      this.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private IntOrStringBuilder maxUnavailable;
  private IntOrStringBuilder minAvailable;
  private LabelSelectorBuilder selector;
  private String unhealthyPodEvictionPolicy;
  private Map<String,Object> additionalProperties;
  public IntOrString buildMaxUnavailable() {
    return this.maxUnavailable!=null ?this.maxUnavailable.build():null;
  }
  public A withMaxUnavailable(IntOrString maxUnavailable) {
    _visitables.get("maxUnavailable").remove(this.maxUnavailable);
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.get("maxUnavailable").add(this.maxUnavailable);} else { this.maxUnavailable = null; _visitables.get("maxUnavailable").remove(this.maxUnavailable); } return (A) this;
  }
  public boolean hasMaxUnavailable() {
    return this.maxUnavailable != null;
  }
  public A withNewMaxUnavailable(Object value) {
    return (A)withMaxUnavailable(new IntOrString(value));
  }
  public MaxUnavailableNested<A> withNewMaxUnavailable() {
    return new MaxUnavailableNested(null);
  }
  public MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item) {
    return new MaxUnavailableNested(item);
  }
  public MaxUnavailableNested<A> editMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(null));
  }
  public MaxUnavailableNested<A> editOrNewMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(new IntOrStringBuilder().build()));
  }
  public MaxUnavailableNested<A> editOrNewMaxUnavailableLike(IntOrString item) {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(item));
  }
  public IntOrString buildMinAvailable() {
    return this.minAvailable!=null ?this.minAvailable.build():null;
  }
  public A withMinAvailable(IntOrString minAvailable) {
    _visitables.get("minAvailable").remove(this.minAvailable);
    if (minAvailable!=null){ this.minAvailable= new IntOrStringBuilder(minAvailable); _visitables.get("minAvailable").add(this.minAvailable);} else { this.minAvailable = null; _visitables.get("minAvailable").remove(this.minAvailable); } return (A) this;
  }
  public boolean hasMinAvailable() {
    return this.minAvailable != null;
  }
  public A withNewMinAvailable(Object value) {
    return (A)withMinAvailable(new IntOrString(value));
  }
  public MinAvailableNested<A> withNewMinAvailable() {
    return new MinAvailableNested(null);
  }
  public MinAvailableNested<A> withNewMinAvailableLike(IntOrString item) {
    return new MinAvailableNested(item);
  }
  public MinAvailableNested<A> editMinAvailable() {
    return withNewMinAvailableLike(java.util.Optional.ofNullable(buildMinAvailable()).orElse(null));
  }
  public MinAvailableNested<A> editOrNewMinAvailable() {
    return withNewMinAvailableLike(java.util.Optional.ofNullable(buildMinAvailable()).orElse(new IntOrStringBuilder().build()));
  }
  public MinAvailableNested<A> editOrNewMinAvailableLike(IntOrString item) {
    return withNewMinAvailableLike(java.util.Optional.ofNullable(buildMinAvailable()).orElse(item));
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  public String getUnhealthyPodEvictionPolicy() {
    return this.unhealthyPodEvictionPolicy;
  }
  public A withUnhealthyPodEvictionPolicy(String unhealthyPodEvictionPolicy) {
    this.unhealthyPodEvictionPolicy=unhealthyPodEvictionPolicy; return (A) this;
  }
  public boolean hasUnhealthyPodEvictionPolicy() {
    return this.unhealthyPodEvictionPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodDisruptionBudgetSpecFluent that = (PodDisruptionBudgetSpecFluent) o;
    if (!java.util.Objects.equals(maxUnavailable, that.maxUnavailable)) return false;

    if (!java.util.Objects.equals(minAvailable, that.minAvailable)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(unhealthyPodEvictionPolicy, that.unhealthyPodEvictionPolicy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(maxUnavailable,  minAvailable,  selector,  unhealthyPodEvictionPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (maxUnavailable != null) { sb.append("maxUnavailable:"); sb.append(maxUnavailable + ","); }
    if (minAvailable != null) { sb.append("minAvailable:"); sb.append(minAvailable + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (unhealthyPodEvictionPolicy != null) { sb.append("unhealthyPodEvictionPolicy:"); sb.append(unhealthyPodEvictionPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MaxUnavailableNested<N> extends IntOrStringFluent<MaxUnavailableNested<N>> implements Nested<N>{
    MaxUnavailableNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) PodDisruptionBudgetSpecFluent.this.withMaxUnavailable(builder.build());
    }
    public N endMaxUnavailable() {
      return and();
    }
    
  }
  public class MinAvailableNested<N> extends IntOrStringFluent<MinAvailableNested<N>> implements Nested<N>{
    MinAvailableNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) PodDisruptionBudgetSpecFluent.this.withMinAvailable(builder.build());
    }
    public N endMinAvailable() {
      return and();
    }
    
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PodDisruptionBudgetSpecFluent.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}