package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SELinuxStrategyOptionsBuilder extends SELinuxStrategyOptionsFluentImpl<SELinuxStrategyOptionsBuilder> implements VisitableBuilder<SELinuxStrategyOptions,SELinuxStrategyOptionsBuilder>{
  public SELinuxStrategyOptionsBuilder() {
    this(false);
  }
  public SELinuxStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new SELinuxStrategyOptions(), validationEnabled);
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SELinuxStrategyOptions(), validationEnabled);
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptionsFluent<?> fluent,SELinuxStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptionsFluent<?> fluent,SELinuxStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRule(instance.getRule());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptions instance) {
    this(instance,false);
  }
  public SELinuxStrategyOptionsBuilder(SELinuxStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRule(instance.getRule());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SELinuxStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SELinuxStrategyOptions build() {
    SELinuxStrategyOptions buildable = new SELinuxStrategyOptions(fluent.getRule(),fluent.getSeLinuxOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}