package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetStatusBuilder extends PodDisruptionBudgetStatusFluentImpl<PodDisruptionBudgetStatusBuilder> implements VisitableBuilder<PodDisruptionBudgetStatus,PodDisruptionBudgetStatusBuilder>{
  public PodDisruptionBudgetStatusBuilder() {
    this(false);
  }
  public PodDisruptionBudgetStatusBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudgetStatus(), validationEnabled);
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudgetStatus(), validationEnabled);
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatusFluent<?> fluent,PodDisruptionBudgetStatus instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatusFluent<?> fluent,PodDisruptionBudgetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentHealthy(instance.getCurrentHealthy());
      fluent.withDesiredHealthy(instance.getDesiredHealthy());
      fluent.withDisruptedPods(instance.getDisruptedPods());
      fluent.withDisruptionsAllowed(instance.getDisruptionsAllowed());
      fluent.withExpectedPods(instance.getExpectedPods());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatus instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetStatusBuilder(PodDisruptionBudgetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withCurrentHealthy(instance.getCurrentHealthy());
      this.withDesiredHealthy(instance.getDesiredHealthy());
      this.withDisruptedPods(instance.getDisruptedPods());
      this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
      this.withExpectedPods(instance.getExpectedPods());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodDisruptionBudgetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodDisruptionBudgetStatus build() {
    PodDisruptionBudgetStatus buildable = new PodDisruptionBudgetStatus(fluent.getConditions(),fluent.getCurrentHealthy(),fluent.getDesiredHealthy(),fluent.getDisruptedPods(),fluent.getDisruptionsAllowed(),fluent.getExpectedPods(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}