package io.fabric8.kubernetes.api.model.policy.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuntimeClassStrategyOptionsFluentImpl<A extends RuntimeClassStrategyOptionsFluent<A>> extends BaseFluent<A> implements RuntimeClassStrategyOptionsFluent<A>{
  public RuntimeClassStrategyOptionsFluentImpl() {
  }
  public RuntimeClassStrategyOptionsFluentImpl(RuntimeClassStrategyOptions instance) {
    this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames()); 
    this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> allowedRuntimeClassNames = new ArrayList<String>();
  private String defaultRuntimeClassName;
  private Map<String,Object> additionalProperties;
  public A addToAllowedRuntimeClassNames(Integer index,String item) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    this.allowedRuntimeClassNames.add(index, item);
    return (A)this;
  }
  public A setToAllowedRuntimeClassNames(Integer index,String item) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    this.allowedRuntimeClassNames.set(index, item); return (A)this;
  }
  public A addToAllowedRuntimeClassNames(java.lang.String... items) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
  }
  public A addAllToAllowedRuntimeClassNames(Collection<String> items) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
  }
  public A removeFromAllowedRuntimeClassNames(java.lang.String... items) {
    for (String item : items) {if (this.allowedRuntimeClassNames!= null){ this.allowedRuntimeClassNames.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedRuntimeClassNames(Collection<String> items) {
    for (String item : items) {if (this.allowedRuntimeClassNames!= null){ this.allowedRuntimeClassNames.remove(item);}} return (A)this;
  }
  public List<String> getAllowedRuntimeClassNames() {
    return this.allowedRuntimeClassNames;
  }
  public String getAllowedRuntimeClassName(Integer index) {
    return this.allowedRuntimeClassNames.get(index);
  }
  public String getFirstAllowedRuntimeClassName() {
    return this.allowedRuntimeClassNames.get(0);
  }
  public String getLastAllowedRuntimeClassName() {
    return this.allowedRuntimeClassNames.get(allowedRuntimeClassNames.size() - 1);
  }
  public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
    for (String item: allowedRuntimeClassNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
    for (String item: allowedRuntimeClassNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
    if (allowedRuntimeClassNames != null) {this.allowedRuntimeClassNames = new ArrayList(); for (String item : allowedRuntimeClassNames){this.addToAllowedRuntimeClassNames(item);}} else { this.allowedRuntimeClassNames = null;} return (A) this;
  }
  public A withAllowedRuntimeClassNames(java.lang.String... allowedRuntimeClassNames) {
    if (this.allowedRuntimeClassNames != null) {this.allowedRuntimeClassNames.clear();}
    if (allowedRuntimeClassNames != null) {for (String item :allowedRuntimeClassNames){ this.addToAllowedRuntimeClassNames(item);}} return (A) this;
  }
  public Boolean hasAllowedRuntimeClassNames() {
    return allowedRuntimeClassNames != null && !allowedRuntimeClassNames.isEmpty();
  }
  public String getDefaultRuntimeClassName() {
    return this.defaultRuntimeClassName;
  }
  public A withDefaultRuntimeClassName(String defaultRuntimeClassName) {
    this.defaultRuntimeClassName=defaultRuntimeClassName; return (A) this;
  }
  public Boolean hasDefaultRuntimeClassName() {
    return this.defaultRuntimeClassName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RuntimeClassStrategyOptionsFluentImpl that = (RuntimeClassStrategyOptionsFluentImpl) o;
    if (allowedRuntimeClassNames != null ? !allowedRuntimeClassNames.equals(that.allowedRuntimeClassNames) :that.allowedRuntimeClassNames != null) return false;
    if (defaultRuntimeClassName != null ? !defaultRuntimeClassName.equals(that.defaultRuntimeClassName) :that.defaultRuntimeClassName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowedRuntimeClassNames,  defaultRuntimeClassName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedRuntimeClassNames != null && !allowedRuntimeClassNames.isEmpty()) { sb.append("allowedRuntimeClassNames:"); sb.append(allowedRuntimeClassNames + ","); }
    if (defaultRuntimeClassName != null) { sb.append("defaultRuntimeClassName:"); sb.append(defaultRuntimeClassName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}