package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SupplementalGroupsStrategyOptionsBuilder extends SupplementalGroupsStrategyOptionsFluentImpl<SupplementalGroupsStrategyOptionsBuilder> implements VisitableBuilder<SupplementalGroupsStrategyOptions,SupplementalGroupsStrategyOptionsBuilder>{
  public SupplementalGroupsStrategyOptionsBuilder() {
    this(false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new SupplementalGroupsStrategyOptions(), validationEnabled);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SupplementalGroupsStrategyOptions(), validationEnabled);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRanges(instance.getRanges()); 
    fluent.withRule(instance.getRule()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance) {
    this(instance,false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRanges(instance.getRanges()); 
    this.withRule(instance.getRule()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SupplementalGroupsStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SupplementalGroupsStrategyOptions build() {
    SupplementalGroupsStrategyOptions buildable = new SupplementalGroupsStrategyOptions(fluent.getRanges(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}