package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetListBuilder extends PodDisruptionBudgetListFluentImpl<PodDisruptionBudgetListBuilder> implements VisitableBuilder<PodDisruptionBudgetList,PodDisruptionBudgetListBuilder>{
  public PodDisruptionBudgetListBuilder() {
    this(false);
  }
  public PodDisruptionBudgetListBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudgetList(), validationEnabled);
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudgetList(), validationEnabled);
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetListFluent<?> fluent,PodDisruptionBudgetList instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetListFluent<?> fluent,PodDisruptionBudgetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetList instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetListBuilder(PodDisruptionBudgetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodDisruptionBudgetListFluent<?> fluent;
  Boolean validationEnabled;
  public PodDisruptionBudgetList build() {
    PodDisruptionBudgetList buildable = new PodDisruptionBudgetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}