package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RunAsUserStrategyOptionsBuilder extends RunAsUserStrategyOptionsFluentImpl<RunAsUserStrategyOptionsBuilder> implements VisitableBuilder<RunAsUserStrategyOptions,RunAsUserStrategyOptionsBuilder>{
  public RunAsUserStrategyOptionsBuilder() {
    this(false);
  }
  public RunAsUserStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new RunAsUserStrategyOptions(), validationEnabled);
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RunAsUserStrategyOptions(), validationEnabled);
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,RunAsUserStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptionsFluent<?> fluent,RunAsUserStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRanges(instance.getRanges()); 
    fluent.withRule(instance.getRule()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptions instance) {
    this(instance,false);
  }
  public RunAsUserStrategyOptionsBuilder(RunAsUserStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRanges(instance.getRanges()); 
    this.withRule(instance.getRule()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RunAsUserStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public RunAsUserStrategyOptions build() {
    RunAsUserStrategyOptions buildable = new RunAsUserStrategyOptions(fluent.getRanges(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}