package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RunAsGroupStrategyOptionsFluentImpl<A extends RunAsGroupStrategyOptionsFluent<A>> extends BaseFluent<A> implements RunAsGroupStrategyOptionsFluent<A>{
  public RunAsGroupStrategyOptionsFluentImpl() {
  }
  public RunAsGroupStrategyOptionsFluentImpl(RunAsGroupStrategyOptions instance) {
    this.withRanges(instance.getRanges()); 
    this.withRule(instance.getRule()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<IDRangeBuilder> ranges = new ArrayList<IDRangeBuilder>();
  private String rule;
  private Map<String,Object> additionalProperties;
  public A addToRanges(Integer index,IDRange item) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").add(index >= 0 ? index : _visitables.get("ranges").size(), builder);this.ranges.add(index >= 0 ? index : ranges.size(), builder); return (A)this;
  }
  public A setToRanges(Integer index,IDRange item) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    IDRangeBuilder builder = new IDRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("ranges").size()) { _visitables.get("ranges").add(builder); } else { _visitables.get("ranges").set(index, builder);}
    if (index < 0 || index >= ranges.size()) { ranges.add(builder); } else { ranges.set(index, builder);}
     return (A)this;
  }
  public A addToRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... items) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
  }
  public A addAllToRanges(Collection<IDRange> items) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
  }
  public A removeFromRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... items) {
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
  }
  public A removeAllFromRanges(Collection<IDRange> items) {
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").remove(builder);if (this.ranges != null) {this.ranges.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRanges(Predicate<IDRangeBuilder> predicate) {
    if (ranges == null) return (A) this;
    final Iterator<IDRangeBuilder> each = ranges.iterator();
    final List visitables = _visitables.get("ranges");
    while (each.hasNext()) {
      IDRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRanges instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IDRange> getRanges() {
    return ranges != null ? build(ranges) : null;
  }
  public List<IDRange> buildRanges() {
    return ranges != null ? build(ranges) : null;
  }
  public IDRange buildRange(Integer index) {
    return this.ranges.get(index).build();
  }
  public IDRange buildFirstRange() {
    return this.ranges.get(0).build();
  }
  public IDRange buildLastRange() {
    return this.ranges.get(ranges.size() - 1).build();
  }
  public IDRange buildMatchingRange(Predicate<IDRangeBuilder> predicate) {
    for (IDRangeBuilder item: ranges) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRange(Predicate<IDRangeBuilder> predicate) {
    for (IDRangeBuilder item: ranges) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRanges(List<IDRange> ranges) {
    if (this.ranges != null) { _visitables.get("ranges").removeAll(this.ranges);}
    if (ranges != null) {this.ranges = new ArrayList(); for (IDRange item : ranges){this.addToRanges(item);}} else { this.ranges = null;} return (A) this;
  }
  public A withRanges(io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange... ranges) {
    if (this.ranges != null) {this.ranges.clear();}
    if (ranges != null) {for (IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
  }
  public Boolean hasRanges() {
    return ranges != null && !ranges.isEmpty();
  }
  public A addNewRange(Long max,Long min) {
    return (A)addToRanges(new IDRange(max, min));
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> addNewRange() {
    return new RunAsGroupStrategyOptionsFluentImpl.RangesNestedImpl();
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item) {
    return new RunAsGroupStrategyOptionsFluentImpl.RangesNestedImpl(-1, item);
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> setNewRangeLike(Integer index,IDRange item) {
    return new RunAsGroupStrategyOptionsFluentImpl.RangesNestedImpl(index, item);
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> editRange(Integer index) {
    if (ranges.size() <= index) throw new RuntimeException("Can't edit ranges. Index exceeds size.");
    return setNewRangeLike(index, buildRange(index));
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> editFirstRange() {
    if (ranges.size() == 0) throw new RuntimeException("Can't edit first ranges. The list is empty.");
    return setNewRangeLike(0, buildRange(0));
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> editLastRange() {
    int index = ranges.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ranges. The list is empty.");
    return setNewRangeLike(index, buildRange(index));
  }
  public RunAsGroupStrategyOptionsFluent.RangesNested<A> editMatchingRange(Predicate<IDRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ranges.size();i++) { 
    if (predicate.test(ranges.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ranges. No match found.");
    return setNewRangeLike(index, buildRange(index));
  }
  public String getRule() {
    return this.rule;
  }
  public A withRule(String rule) {
    this.rule=rule; return (A) this;
  }
  public Boolean hasRule() {
    return this.rule != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RunAsGroupStrategyOptionsFluentImpl that = (RunAsGroupStrategyOptionsFluentImpl) o;
    if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
    if (rule != null ? !rule.equals(that.rule) :that.rule != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ranges,  rule,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ranges != null && !ranges.isEmpty()) { sb.append("ranges:"); sb.append(ranges + ","); }
    if (rule != null) { sb.append("rule:"); sb.append(rule + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RangesNestedImpl<N> extends IDRangeFluentImpl<RunAsGroupStrategyOptionsFluent.RangesNested<N>> implements RunAsGroupStrategyOptionsFluent.RangesNested<N>,Nested<N>{
    RangesNestedImpl(Integer index,IDRange item) {
      this.index = index;
      this.builder = new IDRangeBuilder(this, item);
    }
    RangesNestedImpl() {
      this.index = -1;
      this.builder = new IDRangeBuilder(this);
    }
    IDRangeBuilder builder;
    Integer index;
    public N and() {
      return (N) RunAsGroupStrategyOptionsFluentImpl.this.setToRanges(index,builder.build());
    }
    public N endRange() {
      return and();
    }
    
  }
  
}