package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeClassStrategyOptionsBuilder extends RuntimeClassStrategyOptionsFluentImpl<RuntimeClassStrategyOptionsBuilder> implements VisitableBuilder<RuntimeClassStrategyOptions,RuntimeClassStrategyOptionsBuilder>{
  public RuntimeClassStrategyOptionsBuilder() {
    this(false);
  }
  public RuntimeClassStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new RuntimeClassStrategyOptions(), validationEnabled);
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeClassStrategyOptions(), validationEnabled);
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,RuntimeClassStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,RuntimeClassStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames()); 
    fluent.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptions instance) {
    this(instance,false);
  }
  public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames()); 
    this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RuntimeClassStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeClassStrategyOptions build() {
    RuntimeClassStrategyOptions buildable = new RuntimeClassStrategyOptions(fluent.getAllowedRuntimeClassNames(),fluent.getDefaultRuntimeClassName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}