package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AllowedCSIDriverBuilder extends AllowedCSIDriverFluentImpl<AllowedCSIDriverBuilder> implements VisitableBuilder<AllowedCSIDriver,AllowedCSIDriverBuilder> {

    AllowedCSIDriverFluent<?> fluent;
    Boolean validationEnabled;

    public AllowedCSIDriverBuilder() { 
        this(true);
    }


    public AllowedCSIDriverBuilder(Boolean validationEnabled) { 
        this(new AllowedCSIDriver(), validationEnabled);
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent) { 
        this(fluent, true);
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AllowedCSIDriver(), validationEnabled);
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance) { 
        this(fluent, instance, true);
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriver instance) { 
        this(instance,true);
    }


    public AllowedCSIDriverBuilder(AllowedCSIDriver instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public AllowedCSIDriver build() {
        AllowedCSIDriver buildable = new AllowedCSIDriver(fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AllowedCSIDriverBuilder that = (AllowedCSIDriverBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
