package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPAddressBuilder extends IPAddressFluent<IPAddressBuilder> implements VisitableBuilder<IPAddress,IPAddressBuilder>{
  public IPAddressBuilder() {
    this(false);
  }
  public IPAddressBuilder(Boolean validationEnabled) {
    this(new IPAddress(), validationEnabled);
  }
  public IPAddressBuilder(IPAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public IPAddressBuilder(IPAddressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPAddress(), validationEnabled);
  }
  public IPAddressBuilder(IPAddressFluent<?> fluent,IPAddress instance) {
    this(fluent, instance, false);
  }
  public IPAddressBuilder(IPAddressFluent<?> fluent,IPAddress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IPAddress());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPAddressBuilder(IPAddress instance) {
    this(instance,false);
  }
  public IPAddressBuilder(IPAddress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IPAddress());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPAddressFluent<?> fluent;
  Boolean validationEnabled;
  public IPAddress build() {
    IPAddress buildable = new IPAddress(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}