package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyBuilder extends NetworkPolicyFluent<NetworkPolicyBuilder> implements VisitableBuilder<NetworkPolicy,NetworkPolicyBuilder>{
  public NetworkPolicyBuilder() {
    this(false);
  }
  public NetworkPolicyBuilder(Boolean validationEnabled) {
    this(new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent,NetworkPolicy instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent,NetworkPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkPolicy());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyBuilder(NetworkPolicy instance) {
    this(instance,false);
  }
  public NetworkPolicyBuilder(NetworkPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkPolicy());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicy build() {
    NetworkPolicy buildable = new NetworkPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}