package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressBackendFluent<A extends IngressBackendFluent<A>> extends BaseFluent<A>{
  public IngressBackendFluent() {
  }
  public IngressBackendFluent(IngressBackend instance) {
    instance = (instance != null ? instance : new IngressBackend());

    if (instance != null) {
      this.withResource(instance.getResource());
      this.withService(instance.getService());
      this.withResource(instance.getResource());
      this.withService(instance.getService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private TypedLocalObjectReference resource;
  private IngressServiceBackendBuilder service;
  private Map<String,Object> additionalProperties;
  public TypedLocalObjectReference getResource() {
    return this.resource;
  }
  public A withResource(TypedLocalObjectReference resource) {
    this.resource=resource; return (A) this;
  }
  public boolean hasResource() {
    return this.resource != null;
  }
  public A withNewResource(String apiGroup,String kind,String name) {
    return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public IngressServiceBackend buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(IngressServiceBackend service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new IngressServiceBackendBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public boolean hasService() {
    return this.service != null;
  }
  public ServiceNested<A> withNewService() {
    return new ServiceNested(null);
  }
  public ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
    return new ServiceNested(item);
  }
  public ServiceNested<A> editService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(null));
  }
  public ServiceNested<A> editOrNewService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(new IngressServiceBackendBuilder().build()));
  }
  public ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressBackendFluent that = (IngressBackendFluent) o;
    if (!java.util.Objects.equals(resource, that.resource)) return false;

    if (!java.util.Objects.equals(service, that.service)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resource,  service,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceNested<N> extends IngressServiceBackendFluent<ServiceNested<N>> implements Nested<N>{
    ServiceNested(IngressServiceBackend item) {
      this.builder = new IngressServiceBackendBuilder(this, item);
    }
    IngressServiceBackendBuilder builder;
    public N and() {
      return (N) IngressBackendFluent.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}