package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPIngressPathBuilder extends HTTPIngressPathFluent<HTTPIngressPathBuilder> implements VisitableBuilder<HTTPIngressPath,HTTPIngressPathBuilder>{
  public HTTPIngressPathBuilder() {
    this(false);
  }
  public HTTPIngressPathBuilder(Boolean validationEnabled) {
    this(new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent,HTTPIngressPath instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPIngressPath());

    if (instance != null) {
      fluent.withBackend(instance.getBackend());
      fluent.withPath(instance.getPath());
      fluent.withPathType(instance.getPathType());
      fluent.withBackend(instance.getBackend());
      fluent.withPath(instance.getPath());
      fluent.withPathType(instance.getPathType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressPathBuilder(HTTPIngressPath instance) {
    this(instance,false);
  }
  public HTTPIngressPathBuilder(HTTPIngressPath instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPIngressPath());

    if (instance != null) {
      this.withBackend(instance.getBackend());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withBackend(instance.getBackend());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPIngressPathFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPIngressPath build() {
    HTTPIngressPath buildable = new HTTPIngressPath(fluent.buildBackend(),fluent.getPath(),fluent.getPathType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}