package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceCIDRSpecFluent<A extends ServiceCIDRSpecFluent<A>> extends BaseFluent<A>{
  public ServiceCIDRSpecFluent() {
  }
  
  public ServiceCIDRSpecFluent(ServiceCIDRSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> cidrs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceCIDRSpec instance) {
    instance = (instance != null ? instance : new ServiceCIDRSpec());
    if (instance != null) {
          this.withCidrs(instance.getCidrs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCidrs(int index,String item) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    this.cidrs.add(index, item);
    return (A)this;
  }
  
  public A setToCidrs(int index,String item) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    this.cidrs.set(index, item); return (A)this;
  }
  
  public A addToCidrs(java.lang.String... items) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    for (String item : items) {this.cidrs.add(item);} return (A)this;
  }
  
  public A addAllToCidrs(Collection<String> items) {
    if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
    for (String item : items) {this.cidrs.add(item);} return (A)this;
  }
  
  public A removeFromCidrs(java.lang.String... items) {
    if (this.cidrs == null) return (A)this;
    for (String item : items) { this.cidrs.remove(item);} return (A)this;
  }
  
  public A removeAllFromCidrs(Collection<String> items) {
    if (this.cidrs == null) return (A)this;
    for (String item : items) { this.cidrs.remove(item);} return (A)this;
  }
  
  public List<String> getCidrs() {
    return this.cidrs;
  }
  
  public String getCidr(int index) {
    return this.cidrs.get(index);
  }
  
  public String getFirstCidr() {
    return this.cidrs.get(0);
  }
  
  public String getLastCidr() {
    return this.cidrs.get(cidrs.size() - 1);
  }
  
  public String getMatchingCidr(Predicate<String> predicate) {
      for (String item : cidrs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCidr(Predicate<String> predicate) {
      for (String item : cidrs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCidrs(List<String> cidrs) {
    if (cidrs != null) {
        this.cidrs = new ArrayList();
        for (String item : cidrs) {
          this.addToCidrs(item);
        }
    } else {
      this.cidrs = null;
    }
    return (A) this;
  }
  
  public A withCidrs(java.lang.String... cidrs) {
    if (this.cidrs != null) {
        this.cidrs.clear();
        _visitables.remove("cidrs");
    }
    if (cidrs != null) {
      for (String item : cidrs) {
        this.addToCidrs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCidrs() {
    return this.cidrs != null && !this.cidrs.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceCIDRSpecFluent that = (ServiceCIDRSpecFluent) o;
    if (!java.util.Objects.equals(cidrs, that.cidrs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cidrs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cidrs != null && !cidrs.isEmpty()) { sb.append("cidrs:"); sb.append(cidrs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}