package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder> {

    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder() { 
        this(true);
    }


    public IngressBackendBuilder(Boolean validationEnabled) { 
        this(new IngressBackend(), validationEnabled);
    }


    public IngressBackendBuilder(IngressBackendFluent<?> fluent) { 
        this(fluent, true);
    }


    public IngressBackendBuilder(IngressBackendFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new IngressBackend(), validationEnabled);
    }


    public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance) { 
        this(fluent, instance, true);
    }


    public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withResource(instance.getResource()); 
        fluent.withService(instance.getService()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressBackendBuilder(IngressBackend instance) { 
        this(instance,true);
    }


    public IngressBackendBuilder(IngressBackend instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withResource(instance.getResource()); 
        this.withService(instance.getService()); 
        this.validationEnabled = validationEnabled; 
    }


    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(fluent.getResource(),fluent.getService());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressBackendBuilder that = (IngressBackendBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
