package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NodeMetricsFluent<A extends NodeMetricsFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public NodeMetricsFluent.MetadataNested<A> withNewMetadata();
  public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public NodeMetricsFluent.MetadataNested<A> editMetadata();
  public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata();
  public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public String getTimestamp();
  public A withTimestamp(String timestamp);
  public Boolean hasTimestamp();
  public A addToUsage(String key,Quantity value);
  public A addToUsage(Map<String,Quantity> map);
  public A removeFromUsage(String key);
  public A removeFromUsage(Map<String,Quantity> map);
  public Map<String,Quantity> getUsage();
  public <K,V>A withUsage(Map<String,Quantity> usage);
  public Boolean hasUsage();
  public Duration getWindow();
  public A withWindow(Duration window);
  public Boolean hasWindow();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NodeMetricsFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}