package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PodMetricsFluent<A extends PodMetricsFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToContainers(Integer index,ContainerMetrics item);
  public A setToContainers(Integer index,ContainerMetrics item);
  public A addToContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... items);
  public A addAllToContainers(Collection<ContainerMetrics> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... items);
  public A removeAllFromContainers(Collection<ContainerMetrics> items);
  public A removeMatchingFromContainers(Predicate<ContainerMetricsBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerMetrics> getContainers();
  public List<ContainerMetrics> buildContainers();
  public ContainerMetrics buildContainer(Integer index);
  public ContainerMetrics buildFirstContainer();
  public ContainerMetrics buildLastContainer();
  public ContainerMetrics buildMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
  public A withContainers(List<ContainerMetrics> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... containers);
  public Boolean hasContainers();
  public PodMetricsFluent.ContainersNested<A> addNewContainer();
  public PodMetricsFluent.ContainersNested<A> addNewContainerLike(ContainerMetrics item);
  public PodMetricsFluent.ContainersNested<A> setNewContainerLike(Integer index,ContainerMetrics item);
  public PodMetricsFluent.ContainersNested<A> editContainer(Integer index);
  public PodMetricsFluent.ContainersNested<A> editFirstContainer();
  public PodMetricsFluent.ContainersNested<A> editLastContainer();
  public PodMetricsFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public PodMetricsFluent.MetadataNested<A> withNewMetadata();
  public PodMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public PodMetricsFluent.MetadataNested<A> editMetadata();
  public PodMetricsFluent.MetadataNested<A> editOrNewMetadata();
  public PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public String getTimestamp();
  public A withTimestamp(String timestamp);
  public Boolean hasTimestamp();
  public Duration getWindow();
  public A withWindow(Duration window);
  public Boolean hasWindow();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ContainersNested<N> extends Nested<N>,ContainerMetricsFluent<PodMetricsFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PodMetricsFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}