package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMetricsListBuilder extends PodMetricsListFluentImpl<PodMetricsListBuilder> implements VisitableBuilder<PodMetricsList,PodMetricsListBuilder>{
  public PodMetricsListBuilder() {
    this(false);
  }
  public PodMetricsListBuilder(Boolean validationEnabled) {
    this(new PodMetricsList(), validationEnabled);
  }
  public PodMetricsListBuilder(PodMetricsListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMetricsList(), validationEnabled);
  }
  public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,PodMetricsList instance) {
    this(fluent, instance, false);
  }
  public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,PodMetricsList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodMetricsListBuilder(PodMetricsList instance) {
    this(instance,false);
  }
  public PodMetricsListBuilder(PodMetricsList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodMetricsListFluent<?> fluent;
  Boolean validationEnabled;
  public PodMetricsList build() {
    PodMetricsList buildable = new PodMetricsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}