/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRefBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendRefFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TLSRouteRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TLSRouteRuleFluent<A extends TLSRouteRuleFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<BackendRefBuilder> backendRefs = new ArrayList();
    private String name;

    public TLSRouteRuleFluent() {
    }

    public TLSRouteRuleFluent(TLSRouteRule instance) {
        this.copyInstance(instance);
    }

    public A addAllToBackendRefs(Collection<BackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNested(-1, null);
    }

    public BackendRefsNested<A> addNewBackendRefLike(BackendRef item) {
        return new BackendRefsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBackendRefs(BackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public BackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    public List<BackendRef> buildBackendRefs() {
        return this.backendRefs != null ? TLSRouteRuleFluent.build(this.backendRefs) : null;
    }

    public BackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    public BackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    public BackendRef buildMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TLSRouteRule instance) {
        TLSRouteRule tLSRouteRule = instance = instance != null ? instance : new TLSRouteRule();
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "backendRefs"));
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "backendRefs"));
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    public BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "backendRefs"));
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "backendRefs"));
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSRouteRuleFluent that = (TLSRouteRuleFluent)((Object)o);
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    public boolean hasMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(this.backendRefs, this.name, this.additionalProperties);
    }

    public A removeAllFromBackendRefs(Collection<BackendRef> items) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove((Object)builder);
            this.backendRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromBackendRefs(BackendRef ... items) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove((Object)builder);
            this.backendRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBackendRefs(Predicate<BackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        Iterator<BackendRefBuilder> each = this.backendRefs.iterator();
        List visitables = this._visitables.get((Object)"backendRefs");
        while (each.hasNext()) {
            BackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public BackendRefsNested<A> setNewBackendRefLike(int index, BackendRef item) {
        return new BackendRefsNested(index, item);
    }

    public A setToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null && !this.backendRefs.isEmpty()) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBackendRefs(List<BackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get((Object)"backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)((Object)this);
    }

    public A withBackendRefs(BackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove((Object)"backendRefs");
        }
        if (backendRefs != null) {
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public class BackendRefsNested<N>
    extends BackendRefFluent<BackendRefsNested<N>>
    implements Nested<N> {
        BackendRefBuilder builder;
        int index;

        BackendRefsNested(int index, BackendRef item) {
            this.index = index;
            this.builder = new BackendRefBuilder(this, item);
        }

        public N and() {
            return (N)TLSRouteRuleFluent.this.setToBackendRefs(this.index, this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

