/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCAuthConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCAuthConfigFluent<A extends GRPCAuthConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> allowedHeaders = new ArrayList<String>();

    public GRPCAuthConfigFluent() {
    }

    public GRPCAuthConfigFluent(GRPCAuthConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToAllowedHeaders(Collection<String> items) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllowedHeaders(String ... items) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAllowedHeaders(int index, String item) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        this.allowedHeaders.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(GRPCAuthConfig instance) {
        GRPCAuthConfig gRPCAuthConfig = instance = instance != null ? instance : new GRPCAuthConfig();
        if (instance != null) {
            this.withAllowedHeaders(instance.getAllowedHeaders());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCAuthConfigFluent that = (GRPCAuthConfigFluent)((Object)o);
        if (!Objects.equals(this.allowedHeaders, that.allowedHeaders)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAllowedHeader(int index) {
        return this.allowedHeaders.get(index);
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public String getFirstAllowedHeader() {
        return this.allowedHeaders.get(0);
    }

    public String getLastAllowedHeader() {
        return this.allowedHeaders.get(this.allowedHeaders.size() - 1);
    }

    public String getMatchingAllowedHeader(Predicate<String> predicate) {
        for (String item : this.allowedHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllowedHeaders() {
        return this.allowedHeaders != null && !this.allowedHeaders.isEmpty();
    }

    public boolean hasMatchingAllowedHeader(Predicate<String> predicate) {
        for (String item : this.allowedHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.allowedHeaders, this.additionalProperties);
    }

    public A removeAllFromAllowedHeaders(Collection<String> items) {
        if (this.allowedHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedHeaders(String ... items) {
        if (this.allowedHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAllowedHeaders(int index, String item) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        this.allowedHeaders.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedHeaders != null && !this.allowedHeaders.isEmpty()) {
            sb.append("allowedHeaders:");
            sb.append(this.allowedHeaders);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllowedHeaders(List<String> allowedHeaders) {
        if (allowedHeaders != null) {
            this.allowedHeaders = new ArrayList<String>();
            for (String item : allowedHeaders) {
                this.addToAllowedHeaders(item);
            }
        } else {
            this.allowedHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedHeaders(String ... allowedHeaders) {
        if (this.allowedHeaders != null) {
            this.allowedHeaders.clear();
            this._visitables.remove((Object)"allowedHeaders");
        }
        if (allowedHeaders != null) {
            for (String item : allowedHeaders) {
                this.addToAllowedHeaders(item);
            }
        }
        return (A)((Object)this);
    }
}

