/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FrontendTLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSPortConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSPortConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.TLSPortConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class FrontendTLSConfigFluent<A extends FrontendTLSConfigFluent<A>>
extends BaseFluent<A> {
    private TLSConfigBuilder _default;
    private Map<String, Object> additionalProperties;
    private ArrayList<TLSPortConfigBuilder> perPort = new ArrayList();

    public FrontendTLSConfigFluent() {
    }

    public FrontendTLSConfigFluent(FrontendTLSConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToPerPort(Collection<TLSPortConfig> items) {
        if (this.perPort == null) {
            this.perPort = new ArrayList();
        }
        for (TLSPortConfig item : items) {
            TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.add(builder);
        }
        return (A)((Object)this);
    }

    public PerPortNested<A> addNewPerPort() {
        return new PerPortNested(-1, null);
    }

    public PerPortNested<A> addNewPerPortLike(TLSPortConfig item) {
        return new PerPortNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPerPort(TLSPortConfig ... items) {
        if (this.perPort == null) {
            this.perPort = new ArrayList();
        }
        for (TLSPortConfig item : items) {
            TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPerPort(int index, TLSPortConfig item) {
        if (this.perPort == null) {
            this.perPort = new ArrayList();
        }
        TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
        if (index < 0 || index >= this.perPort.size()) {
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.add(builder);
        } else {
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TLSConfig buildDefault() {
        return this._default != null ? this._default.build() : null;
    }

    public TLSPortConfig buildFirstPerPort() {
        return this.perPort.get(0).build();
    }

    public TLSPortConfig buildLastPerPort() {
        return this.perPort.get(this.perPort.size() - 1).build();
    }

    public TLSPortConfig buildMatchingPerPort(Predicate<TLSPortConfigBuilder> predicate) {
        for (TLSPortConfigBuilder item : this.perPort) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<TLSPortConfig> buildPerPort() {
        return this.perPort != null ? FrontendTLSConfigFluent.build(this.perPort) : null;
    }

    public TLSPortConfig buildPerPort(int index) {
        return this.perPort.get(index).build();
    }

    protected void copyInstance(FrontendTLSConfig instance) {
        FrontendTLSConfig frontendTLSConfig = instance = instance != null ? instance : new FrontendTLSConfig();
        if (instance != null) {
            this.withDefault(instance.getDefault());
            this.withPerPort(instance.getPerPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DefaultNested<A> editDefault() {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(null));
    }

    public PerPortNested<A> editFirstPerPort() {
        if (this.perPort.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "perPort"));
        }
        return this.setNewPerPortLike(0, this.buildPerPort(0));
    }

    public PerPortNested<A> editLastPerPort() {
        int index = this.perPort.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "perPort"));
        }
        return this.setNewPerPortLike(index, this.buildPerPort(index));
    }

    public PerPortNested<A> editMatchingPerPort(Predicate<TLSPortConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.perPort.size(); ++i) {
            if (!predicate.test(this.perPort.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "perPort"));
        }
        return this.setNewPerPortLike(index, this.buildPerPort(index));
    }

    public DefaultNested<A> editOrNewDefault() {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(new TLSConfigBuilder().build()));
    }

    public DefaultNested<A> editOrNewDefaultLike(TLSConfig item) {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(item));
    }

    public PerPortNested<A> editPerPort(int index) {
        if (this.perPort.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "perPort"));
        }
        return this.setNewPerPortLike(index, this.buildPerPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FrontendTLSConfigFluent that = (FrontendTLSConfigFluent)((Object)o);
        if (!Objects.equals((Object)this._default, (Object)that._default)) {
            return false;
        }
        if (!Objects.equals(this.perPort, that.perPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDefault() {
        return this._default != null;
    }

    public boolean hasMatchingPerPort(Predicate<TLSPortConfigBuilder> predicate) {
        for (TLSPortConfigBuilder item : this.perPort) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPerPort() {
        return this.perPort != null && !this.perPort.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._default, this.perPort, this.additionalProperties});
    }

    public A removeAllFromPerPort(Collection<TLSPortConfig> items) {
        if (this.perPort == null) {
            return (A)((Object)this);
        }
        for (TLSPortConfig item : items) {
            TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
            this._visitables.get((Object)"perPort").remove((Object)builder);
            this.perPort.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPerPort(TLSPortConfig ... items) {
        if (this.perPort == null) {
            return (A)((Object)this);
        }
        for (TLSPortConfig item : items) {
            TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
            this._visitables.get((Object)"perPort").remove((Object)builder);
            this.perPort.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPerPort(Predicate<TLSPortConfigBuilder> predicate) {
        if (this.perPort == null) {
            return (A)((Object)this);
        }
        Iterator<TLSPortConfigBuilder> each = this.perPort.iterator();
        List visitables = this._visitables.get((Object)"perPort");
        while (each.hasNext()) {
            TLSPortConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public PerPortNested<A> setNewPerPortLike(int index, TLSPortConfig item) {
        return new PerPortNested(index, item);
    }

    public A setToPerPort(int index, TLSPortConfig item) {
        if (this.perPort == null) {
            this.perPort = new ArrayList();
        }
        TLSPortConfigBuilder builder = new TLSPortConfigBuilder(item);
        if (index < 0 || index >= this.perPort.size()) {
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.add(builder);
        } else {
            this._visitables.get((Object)"perPort").add(builder);
            this.perPort.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._default != null) {
            sb.append("_default:");
            sb.append((Object)this._default);
            sb.append(",");
        }
        if (this.perPort != null && !this.perPort.isEmpty()) {
            sb.append("perPort:");
            sb.append(this.perPort);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDefault(TLSConfig _default) {
        this._visitables.remove((Object)"_default");
        if (_default != null) {
            this._default = new TLSConfigBuilder(_default);
            this._visitables.get((Object)"_default").add(this._default);
        } else {
            this._default = null;
            this._visitables.get((Object)"_default").remove((Object)this._default);
        }
        return (A)((Object)this);
    }

    public DefaultNested<A> withNewDefault() {
        return new DefaultNested(null);
    }

    public DefaultNested<A> withNewDefaultLike(TLSConfig item) {
        return new DefaultNested(item);
    }

    public A withPerPort(List<TLSPortConfig> perPort) {
        if (this.perPort != null) {
            this._visitables.get((Object)"perPort").clear();
        }
        if (perPort != null) {
            this.perPort = new ArrayList();
            for (TLSPortConfig item : perPort) {
                this.addToPerPort(item);
            }
        } else {
            this.perPort = null;
        }
        return (A)((Object)this);
    }

    public A withPerPort(TLSPortConfig ... perPort) {
        if (this.perPort != null) {
            this.perPort.clear();
            this._visitables.remove((Object)"perPort");
        }
        if (perPort != null) {
            for (TLSPortConfig item : perPort) {
                this.addToPerPort(item);
            }
        }
        return (A)((Object)this);
    }

    public class PerPortNested<N>
    extends TLSPortConfigFluent<PerPortNested<N>>
    implements Nested<N> {
        TLSPortConfigBuilder builder;
        int index;

        PerPortNested(int index, TLSPortConfig item) {
            this.index = index;
            this.builder = new TLSPortConfigBuilder(this, item);
        }

        public N and() {
            return (N)FrontendTLSConfigFluent.this.setToPerPort(this.index, this.builder.build());
        }

        public N endPerPort() {
            return this.and();
        }
    }

    public class DefaultNested<N>
    extends TLSConfigFluent<DefaultNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        DefaultNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)FrontendTLSConfigFluent.this.withDefault(this.builder.build());
        }

        public N endDefault() {
            return this.and();
        }
    }
}

