package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GatewayTLSConfigBuilder extends GatewayTLSConfigFluent<GatewayTLSConfigBuilder> implements VisitableBuilder<GatewayTLSConfig,GatewayTLSConfigBuilder>{
  public GatewayTLSConfigBuilder() {
    this(new GatewayTLSConfig());
  }
  
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent) {
    this(fluent, new GatewayTLSConfig());
  }
  
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent,GatewayTLSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GatewayTLSConfigBuilder(GatewayTLSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GatewayTLSConfigFluent<?> fluent;
  
  public GatewayTLSConfig build() {
    GatewayTLSConfig buildable = new GatewayTLSConfig(fluent.buildCertificateRefs(),fluent.buildFrontendValidation(),fluent.getMode(),fluent.getOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}