package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteSpecBuilder extends TLSRouteSpecFluent<TLSRouteSpecBuilder> implements VisitableBuilder<TLSRouteSpec,TLSRouteSpecBuilder>{
  public TLSRouteSpecBuilder() {
    this(false);
  }
  public TLSRouteSpecBuilder(Boolean validationEnabled) {
    this(new TLSRouteSpec(), validationEnabled);
  }
  public TLSRouteSpecBuilder(TLSRouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteSpecBuilder(TLSRouteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRouteSpec(), validationEnabled);
  }
  public TLSRouteSpecBuilder(TLSRouteSpecFluent<?> fluent,TLSRouteSpec instance) {
    this(fluent, instance, false);
  }
  public TLSRouteSpecBuilder(TLSRouteSpecFluent<?> fluent,TLSRouteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSRouteSpec());

    if (instance != null) {
      fluent.withHostnames(instance.getHostnames());
      fluent.withParentRefs(instance.getParentRefs());
      fluent.withRules(instance.getRules());
      fluent.withHostnames(instance.getHostnames());
      fluent.withParentRefs(instance.getParentRefs());
      fluent.withRules(instance.getRules());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteSpecBuilder(TLSRouteSpec instance) {
    this(instance,false);
  }
  public TLSRouteSpecBuilder(TLSRouteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSRouteSpec());

    if (instance != null) {
      this.withHostnames(instance.getHostnames());
      this.withParentRefs(instance.getParentRefs());
      this.withRules(instance.getRules());
      this.withHostnames(instance.getHostnames());
      this.withParentRefs(instance.getParentRefs());
      this.withRules(instance.getRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRouteSpec build() {
    TLSRouteSpec buildable = new TLSRouteSpec(fluent.getHostnames(),fluent.buildParentRefs(),fluent.buildRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}