package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteRuleBuilder extends TLSRouteRuleFluent<TLSRouteRuleBuilder> implements VisitableBuilder<TLSRouteRule,TLSRouteRuleBuilder>{
  public TLSRouteRuleBuilder() {
    this(false);
  }
  public TLSRouteRuleBuilder(Boolean validationEnabled) {
    this(new TLSRouteRule(), validationEnabled);
  }
  public TLSRouteRuleBuilder(TLSRouteRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteRuleBuilder(TLSRouteRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRouteRule(), validationEnabled);
  }
  public TLSRouteRuleBuilder(TLSRouteRuleFluent<?> fluent,TLSRouteRule instance) {
    this(fluent, instance, false);
  }
  public TLSRouteRuleBuilder(TLSRouteRuleFluent<?> fluent,TLSRouteRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSRouteRule());

    if (instance != null) {
      fluent.withBackendRefs(instance.getBackendRefs());
      fluent.withBackendRefs(instance.getBackendRefs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteRuleBuilder(TLSRouteRule instance) {
    this(instance,false);
  }
  public TLSRouteRuleBuilder(TLSRouteRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSRouteRule());

    if (instance != null) {
      this.withBackendRefs(instance.getBackendRefs());
      this.withBackendRefs(instance.getBackendRefs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteRuleFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRouteRule build() {
    TLSRouteRule buildable = new TLSRouteRule(fluent.buildBackendRefs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}