package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCRouteSpecBuilder extends GRPCRouteSpecFluent<GRPCRouteSpecBuilder> implements VisitableBuilder<GRPCRouteSpec,GRPCRouteSpecBuilder>{
  public GRPCRouteSpecBuilder() {
    this(false);
  }
  public GRPCRouteSpecBuilder(Boolean validationEnabled) {
    this(new GRPCRouteSpec(), validationEnabled);
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCRouteSpec(), validationEnabled);
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpecFluent<?> fluent,GRPCRouteSpec instance) {
    this(fluent, instance, false);
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpecFluent<?> fluent,GRPCRouteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GRPCRouteSpec());

    if (instance != null) {
      fluent.withHostnames(instance.getHostnames());
      fluent.withParentRefs(instance.getParentRefs());
      fluent.withRules(instance.getRules());
      fluent.withHostnames(instance.getHostnames());
      fluent.withParentRefs(instance.getParentRefs());
      fluent.withRules(instance.getRules());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpec instance) {
    this(instance,false);
  }
  public GRPCRouteSpecBuilder(GRPCRouteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GRPCRouteSpec());

    if (instance != null) {
      this.withHostnames(instance.getHostnames());
      this.withParentRefs(instance.getParentRefs());
      this.withRules(instance.getRules());
      this.withHostnames(instance.getHostnames());
      this.withParentRefs(instance.getParentRefs());
      this.withRules(instance.getRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCRouteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCRouteSpec build() {
    GRPCRouteSpec buildable = new GRPCRouteSpec(fluent.getHostnames(),fluent.buildParentRefs(),fluent.buildRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}