package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParentReferenceBuilder extends ParentReferenceFluentImpl<ParentReferenceBuilder> implements VisitableBuilder<ParentReference,ParentReferenceBuilder>{
  public ParentReferenceBuilder() {
    this(false);
  }
  public ParentReferenceBuilder(Boolean validationEnabled) {
    this(new ParentReference(), validationEnabled);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParentReference(), validationEnabled);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,ParentReference instance) {
    this(fluent, instance, false);
  }
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,ParentReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPort(instance.getPort()); 
    fluent.withSectionName(instance.getSectionName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ParentReferenceBuilder(ParentReference instance) {
    this(instance,false);
  }
  public ParentReferenceBuilder(ParentReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withSectionName(instance.getSectionName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ParentReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ParentReference build() {
    ParentReference buildable = new ParentReference(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPort(),fluent.getSectionName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}