package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UDPRouteListFluentImpl<A extends UDPRouteListFluent<A>> extends BaseFluent<A> implements UDPRouteListFluent<A>{
  public UDPRouteListFluentImpl() {
  }
  public UDPRouteListFluentImpl(UDPRouteList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<UDPRouteBuilder> items = new ArrayList<UDPRouteBuilder>();
  private String kind;
  private ListMeta metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(Integer index,UDPRoute item) {
    if (this.items == null) {this.items = new ArrayList<UDPRouteBuilder>();}
    UDPRouteBuilder builder = new UDPRouteBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(Integer index,UDPRoute item) {
    if (this.items == null) {this.items = new ArrayList<UDPRouteBuilder>();}
    UDPRouteBuilder builder = new UDPRouteBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRoute... items) {
    if (this.items == null) {this.items = new ArrayList<UDPRouteBuilder>();}
    for (UDPRoute item : items) {UDPRouteBuilder builder = new UDPRouteBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<UDPRoute> items) {
    if (this.items == null) {this.items = new ArrayList<UDPRouteBuilder>();}
    for (UDPRoute item : items) {UDPRouteBuilder builder = new UDPRouteBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRoute... items) {
    for (UDPRoute item : items) {UDPRouteBuilder builder = new UDPRouteBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<UDPRoute> items) {
    for (UDPRoute item : items) {UDPRouteBuilder builder = new UDPRouteBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<UDPRouteBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<UDPRouteBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      UDPRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<UDPRoute> getItems() {
    return items != null ? build(items) : null;
  }
  public List<UDPRoute> buildItems() {
    return items != null ? build(items) : null;
  }
  public UDPRoute buildItem(Integer index) {
    return this.items.get(index).build();
  }
  public UDPRoute buildFirstItem() {
    return this.items.get(0).build();
  }
  public UDPRoute buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public UDPRoute buildMatchingItem(Predicate<UDPRouteBuilder> predicate) {
    for (UDPRouteBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<UDPRouteBuilder> predicate) {
    for (UDPRouteBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<UDPRoute> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new ArrayList(); for (UDPRoute item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRoute... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (UDPRoute item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public UDPRouteListFluent.ItemsNested<A> addNewItem() {
    return new UDPRouteListFluentImpl.ItemsNestedImpl();
  }
  public UDPRouteListFluent.ItemsNested<A> addNewItemLike(UDPRoute item) {
    return new UDPRouteListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public UDPRouteListFluent.ItemsNested<A> setNewItemLike(Integer index,UDPRoute item) {
    return new UDPRouteListFluentImpl.ItemsNestedImpl(index, item);
  }
  public UDPRouteListFluent.ItemsNested<A> editItem(Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public UDPRouteListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public UDPRouteListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public UDPRouteListFluent.ItemsNested<A> editMatchingItem(Predicate<UDPRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UDPRouteListFluentImpl that = (UDPRouteListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends UDPRouteFluentImpl<UDPRouteListFluent.ItemsNested<N>> implements UDPRouteListFluent.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(Integer index,UDPRoute item) {
      this.index = index;
      this.builder = new UDPRouteBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new UDPRouteBuilder(this);
    }
    UDPRouteBuilder builder;
    Integer index;
    public N and() {
      return (N) UDPRouteListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}