package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UDPRouteBuilder extends UDPRouteFluentImpl<UDPRouteBuilder> implements VisitableBuilder<UDPRoute,UDPRouteBuilder>{
  public UDPRouteBuilder() {
    this(false);
  }
  public UDPRouteBuilder(Boolean validationEnabled) {
    this(new UDPRoute(), validationEnabled);
  }
  public UDPRouteBuilder(UDPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public UDPRouteBuilder(UDPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UDPRoute(), validationEnabled);
  }
  public UDPRouteBuilder(UDPRouteFluent<?> fluent,UDPRoute instance) {
    this(fluent, instance, false);
  }
  public UDPRouteBuilder(UDPRouteFluent<?> fluent,UDPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UDPRouteBuilder(UDPRoute instance) {
    this(instance,false);
  }
  public UDPRouteBuilder(UDPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UDPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public UDPRoute build() {
    UDPRoute buildable = new UDPRoute(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}