package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GRPCRouteRuleFluentImpl<A extends GRPCRouteRuleFluent<A>> extends BaseFluent<A> implements GRPCRouteRuleFluent<A>{
  public GRPCRouteRuleFluentImpl() {
  }
  public GRPCRouteRuleFluentImpl(GRPCRouteRule instance) {
    this.withBackendRefs(instance.getBackendRefs()); 
    this.withFilters(instance.getFilters()); 
    this.withMatches(instance.getMatches()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<GRPCBackendRefBuilder> backendRefs = new ArrayList<GRPCBackendRefBuilder>();
  private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList<GRPCRouteFilterBuilder>();
  private ArrayList<GRPCRouteMatchBuilder> matches = new ArrayList<GRPCRouteMatchBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToBackendRefs(Integer index,GRPCBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").add(index >= 0 ? index : _visitables.get("backendRefs").size(), builder);this.backendRefs.add(index >= 0 ? index : backendRefs.size(), builder); return (A)this;
  }
  public A setToBackendRefs(Integer index,GRPCBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
    if (index < 0 || index >= _visitables.get("backendRefs").size()) { _visitables.get("backendRefs").add(builder); } else { _visitables.get("backendRefs").set(index, builder);}
    if (index < 0 || index >= backendRefs.size()) { backendRefs.add(builder); } else { backendRefs.set(index, builder);}
     return (A)this;
  }
  public A addToBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A addAllToBackendRefs(Collection<GRPCBackendRef> items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A removeFromBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... items) {
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeAllFromBackendRefs(Collection<GRPCBackendRef> items) {
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBackendRefs(Predicate<GRPCBackendRefBuilder> predicate) {
    if (backendRefs == null) return (A) this;
    final Iterator<GRPCBackendRefBuilder> each = backendRefs.iterator();
    final List visitables = _visitables.get("backendRefs");
    while (each.hasNext()) {
      GRPCBackendRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBackendRefs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GRPCBackendRef> getBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public List<GRPCBackendRef> buildBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public GRPCBackendRef buildBackendRef(Integer index) {
    return this.backendRefs.get(index).build();
  }
  public GRPCBackendRef buildFirstBackendRef() {
    return this.backendRefs.get(0).build();
  }
  public GRPCBackendRef buildLastBackendRef() {
    return this.backendRefs.get(backendRefs.size() - 1).build();
  }
  public GRPCBackendRef buildMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    for (GRPCBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    for (GRPCBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBackendRefs(List<GRPCBackendRef> backendRefs) {
    if (this.backendRefs != null) { _visitables.get("backendRefs").removeAll(this.backendRefs);}
    if (backendRefs != null) {this.backendRefs = new ArrayList(); for (GRPCBackendRef item : backendRefs){this.addToBackendRefs(item);}} else { this.backendRefs = null;} return (A) this;
  }
  public A withBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... backendRefs) {
    if (this.backendRefs != null) {this.backendRefs.clear();}
    if (backendRefs != null) {for (GRPCBackendRef item :backendRefs){ this.addToBackendRefs(item);}} return (A) this;
  }
  public Boolean hasBackendRefs() {
    return backendRefs != null && !backendRefs.isEmpty();
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> addNewBackendRef() {
    return new GRPCRouteRuleFluentImpl.BackendRefsNestedImpl();
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> addNewBackendRefLike(GRPCBackendRef item) {
    return new GRPCRouteRuleFluentImpl.BackendRefsNestedImpl(-1, item);
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> setNewBackendRefLike(Integer index,GRPCBackendRef item) {
    return new GRPCRouteRuleFluentImpl.BackendRefsNestedImpl(index, item);
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> editBackendRef(Integer index) {
    if (backendRefs.size() <= index) throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> editFirstBackendRef() {
    if (backendRefs.size() == 0) throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
    return setNewBackendRefLike(0, buildBackendRef(0));
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> editLastBackendRef() {
    int index = backendRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public GRPCRouteRuleFluent.BackendRefsNested<A> editMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<backendRefs.size();i++) { 
    if (predicate.test(backendRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching backendRefs. No match found.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public A addToFilters(Integer index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(index >= 0 ? index : _visitables.get("filters").size(), builder);this.filters.add(index >= 0 ? index : filters.size(), builder); return (A)this;
  }
  public A setToFilters(Integer index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= _visitables.get("filters").size()) { _visitables.get("filters").add(builder); } else { _visitables.get("filters").set(index, builder);}
    if (index < 0 || index >= filters.size()) { filters.add(builder); } else { filters.set(index, builder);}
     return (A)this;
  }
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<GRPCRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      GRPCRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFilters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GRPCRouteFilter> getFilters() {
    return filters != null ? build(filters) : null;
  }
  public List<GRPCRouteFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public GRPCRouteFilter buildFilter(Integer index) {
    return this.filters.get(index).build();
  }
  public GRPCRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public GRPCRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<GRPCRouteFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").removeAll(this.filters);}
    if (filters != null) {this.filters = new ArrayList(); for (GRPCRouteFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... filters) {
    if (this.filters != null) {this.filters.clear();}
    if (filters != null) {for (GRPCRouteFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public Boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public GRPCRouteRuleFluent.FiltersNested<A> addNewFilter() {
    return new GRPCRouteRuleFluentImpl.FiltersNestedImpl();
  }
  public GRPCRouteRuleFluent.FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
    return new GRPCRouteRuleFluentImpl.FiltersNestedImpl(-1, item);
  }
  public GRPCRouteRuleFluent.FiltersNested<A> setNewFilterLike(Integer index,GRPCRouteFilter item) {
    return new GRPCRouteRuleFluentImpl.FiltersNestedImpl(index, item);
  }
  public GRPCRouteRuleFluent.FiltersNested<A> editFilter(Integer index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public GRPCRouteRuleFluent.FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public GRPCRouteRuleFluent.FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public GRPCRouteRuleFluent.FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public A addToMatches(Integer index,GRPCRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").add(index >= 0 ? index : _visitables.get("matches").size(), builder);this.matches.add(index >= 0 ? index : matches.size(), builder); return (A)this;
  }
  public A setToMatches(Integer index,GRPCRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
    if (index < 0 || index >= _visitables.get("matches").size()) { _visitables.get("matches").add(builder); } else { _visitables.get("matches").set(index, builder);}
    if (index < 0 || index >= matches.size()) { matches.add(builder); } else { matches.set(index, builder);}
     return (A)this;
  }
  public A addToMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... items) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A addAllToMatches(Collection<GRPCRouteMatch> items) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A removeFromMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... items) {
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").remove(builder);if (this.matches != null) {this.matches.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatches(Collection<GRPCRouteMatch> items) {
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").remove(builder);if (this.matches != null) {this.matches.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatches(Predicate<GRPCRouteMatchBuilder> predicate) {
    if (matches == null) return (A) this;
    final Iterator<GRPCRouteMatchBuilder> each = matches.iterator();
    final List visitables = _visitables.get("matches");
    while (each.hasNext()) {
      GRPCRouteMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatches instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GRPCRouteMatch> getMatches() {
    return matches != null ? build(matches) : null;
  }
  public List<GRPCRouteMatch> buildMatches() {
    return matches != null ? build(matches) : null;
  }
  public GRPCRouteMatch buildMatch(Integer index) {
    return this.matches.get(index).build();
  }
  public GRPCRouteMatch buildFirstMatch() {
    return this.matches.get(0).build();
  }
  public GRPCRouteMatch buildLastMatch() {
    return this.matches.get(matches.size() - 1).build();
  }
  public GRPCRouteMatch buildMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    for (GRPCRouteMatchBuilder item: matches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    for (GRPCRouteMatchBuilder item: matches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatches(List<GRPCRouteMatch> matches) {
    if (this.matches != null) { _visitables.get("matches").removeAll(this.matches);}
    if (matches != null) {this.matches = new ArrayList(); for (GRPCRouteMatch item : matches){this.addToMatches(item);}} else { this.matches = null;} return (A) this;
  }
  public A withMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... matches) {
    if (this.matches != null) {this.matches.clear();}
    if (matches != null) {for (GRPCRouteMatch item :matches){ this.addToMatches(item);}} return (A) this;
  }
  public Boolean hasMatches() {
    return matches != null && !matches.isEmpty();
  }
  public GRPCRouteRuleFluent.MatchesNested<A> addNewMatch() {
    return new GRPCRouteRuleFluentImpl.MatchesNestedImpl();
  }
  public GRPCRouteRuleFluent.MatchesNested<A> addNewMatchLike(GRPCRouteMatch item) {
    return new GRPCRouteRuleFluentImpl.MatchesNestedImpl(-1, item);
  }
  public GRPCRouteRuleFluent.MatchesNested<A> setNewMatchLike(Integer index,GRPCRouteMatch item) {
    return new GRPCRouteRuleFluentImpl.MatchesNestedImpl(index, item);
  }
  public GRPCRouteRuleFluent.MatchesNested<A> editMatch(Integer index) {
    if (matches.size() <= index) throw new RuntimeException("Can't edit matches. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public GRPCRouteRuleFluent.MatchesNested<A> editFirstMatch() {
    if (matches.size() == 0) throw new RuntimeException("Can't edit first matches. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public GRPCRouteRuleFluent.MatchesNested<A> editLastMatch() {
    int index = matches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matches. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public GRPCRouteRuleFluent.MatchesNested<A> editMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matches.size();i++) { 
    if (predicate.test(matches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matches. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GRPCRouteRuleFluentImpl that = (GRPCRouteRuleFluentImpl) o;
    if (backendRefs != null ? !backendRefs.equals(that.backendRefs) :that.backendRefs != null) return false;
    if (filters != null ? !filters.equals(that.filters) :that.filters != null) return false;
    if (matches != null ? !matches.equals(that.matches) :that.matches != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backendRefs,  filters,  matches,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRefs != null && !backendRefs.isEmpty()) { sb.append("backendRefs:"); sb.append(backendRefs + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (matches != null && !matches.isEmpty()) { sb.append("matches:"); sb.append(matches + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BackendRefsNestedImpl<N> extends GRPCBackendRefFluentImpl<GRPCRouteRuleFluent.BackendRefsNested<N>> implements GRPCRouteRuleFluent.BackendRefsNested<N>,Nested<N>{
    BackendRefsNestedImpl(Integer index,GRPCBackendRef item) {
      this.index = index;
      this.builder = new GRPCBackendRefBuilder(this, item);
    }
    BackendRefsNestedImpl() {
      this.index = -1;
      this.builder = new GRPCBackendRefBuilder(this);
    }
    GRPCBackendRefBuilder builder;
    Integer index;
    public N and() {
      return (N) GRPCRouteRuleFluentImpl.this.setToBackendRefs(index,builder.build());
    }
    public N endBackendRef() {
      return and();
    }
    
  }
  class FiltersNestedImpl<N> extends GRPCRouteFilterFluentImpl<GRPCRouteRuleFluent.FiltersNested<N>> implements GRPCRouteRuleFluent.FiltersNested<N>,Nested<N>{
    FiltersNestedImpl(Integer index,GRPCRouteFilter item) {
      this.index = index;
      this.builder = new GRPCRouteFilterBuilder(this, item);
    }
    FiltersNestedImpl() {
      this.index = -1;
      this.builder = new GRPCRouteFilterBuilder(this);
    }
    GRPCRouteFilterBuilder builder;
    Integer index;
    public N and() {
      return (N) GRPCRouteRuleFluentImpl.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class MatchesNestedImpl<N> extends GRPCRouteMatchFluentImpl<GRPCRouteRuleFluent.MatchesNested<N>> implements GRPCRouteRuleFluent.MatchesNested<N>,Nested<N>{
    MatchesNestedImpl(Integer index,GRPCRouteMatch item) {
      this.index = index;
      this.builder = new GRPCRouteMatchBuilder(this, item);
    }
    MatchesNestedImpl() {
      this.index = -1;
      this.builder = new GRPCRouteMatchBuilder(this);
    }
    GRPCRouteMatchBuilder builder;
    Integer index;
    public N and() {
      return (N) GRPCRouteRuleFluentImpl.this.setToMatches(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  
}