package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretObjectReferenceBuilder extends SecretObjectReferenceFluentImpl<SecretObjectReferenceBuilder> implements VisitableBuilder<SecretObjectReference,SecretObjectReferenceBuilder>{
  public SecretObjectReferenceBuilder() {
    this(false);
  }
  public SecretObjectReferenceBuilder(Boolean validationEnabled) {
    this(new SecretObjectReference(), validationEnabled);
  }
  public SecretObjectReferenceBuilder(SecretObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretObjectReferenceBuilder(SecretObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretObjectReference(), validationEnabled);
  }
  public SecretObjectReferenceBuilder(SecretObjectReferenceFluent<?> fluent,SecretObjectReference instance) {
    this(fluent, instance, false);
  }
  public SecretObjectReferenceBuilder(SecretObjectReferenceFluent<?> fluent,SecretObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretObjectReferenceBuilder(SecretObjectReference instance) {
    this(instance,false);
  }
  public SecretObjectReferenceBuilder(SecretObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SecretObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretObjectReference build() {
    SecretObjectReference buildable = new SecretObjectReference(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}