package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteNamespacesBuilder extends RouteNamespacesFluentImpl<RouteNamespacesBuilder> implements VisitableBuilder<RouteNamespaces,RouteNamespacesBuilder>{
  public RouteNamespacesBuilder() {
    this(false);
  }
  public RouteNamespacesBuilder(Boolean validationEnabled) {
    this(new RouteNamespaces(), validationEnabled);
  }
  public RouteNamespacesBuilder(RouteNamespacesFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteNamespacesBuilder(RouteNamespacesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteNamespaces(), validationEnabled);
  }
  public RouteNamespacesBuilder(RouteNamespacesFluent<?> fluent,RouteNamespaces instance) {
    this(fluent, instance, false);
  }
  public RouteNamespacesBuilder(RouteNamespacesFluent<?> fluent,RouteNamespaces instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteNamespacesBuilder(RouteNamespaces instance) {
    this(instance,false);
  }
  public RouteNamespacesBuilder(RouteNamespaces instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RouteNamespacesFluent<?> fluent;
  Boolean validationEnabled;
  public RouteNamespaces build() {
    RouteNamespaces buildable = new RouteNamespaces(fluent.getFrom(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}