package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPHeaderMatchBuilder extends HTTPHeaderMatchFluentImpl<HTTPHeaderMatchBuilder> implements VisitableBuilder<HTTPHeaderMatch,HTTPHeaderMatchBuilder>{
  public HTTPHeaderMatchBuilder() {
    this(false);
  }
  public HTTPHeaderMatchBuilder(Boolean validationEnabled) {
    this(new HTTPHeaderMatch(), validationEnabled);
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPHeaderMatch(), validationEnabled);
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatchFluent<?> fluent,HTTPHeaderMatch instance) {
    this(fluent, instance, false);
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatchFluent<?> fluent,HTTPHeaderMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatch instance) {
    this(instance,false);
  }
  public HTTPHeaderMatchBuilder(HTTPHeaderMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPHeaderMatchFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPHeaderMatch build() {
    HTTPHeaderMatch buildable = new HTTPHeaderMatch(fluent.getName(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}