/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.BackendTLSPolicyConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BackendTLSPolicyConfigFluent<A extends BackendTLSPolicyConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LocalObjectReferenceBuilder> caCertRefs = new ArrayList();
    private String hostname;
    private String wellKnownCACerts;
    private Map<String, Object> additionalProperties;

    public BackendTLSPolicyConfigFluent() {
    }

    public BackendTLSPolicyConfigFluent(BackendTLSPolicyConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackendTLSPolicyConfig instance) {
        BackendTLSPolicyConfig backendTLSPolicyConfig = instance = instance != null ? instance : new BackendTLSPolicyConfig();
        if (instance != null) {
            this.withCaCertRefs(instance.getCaCertRefs());
            this.withHostname(instance.getHostname());
            this.withWellKnownCACerts(instance.getWellKnownCACerts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCaCertRefs(int index, LocalObjectReference item) {
        if (this.caCertRefs == null) {
            this.caCertRefs = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertRefs.size()) {
            this._visitables.get((Object)"caCertRefs").add(builder);
            this.caCertRefs.add(builder);
        } else {
            this._visitables.get((Object)"caCertRefs").add(index, builder);
            this.caCertRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCaCertRefs(int index, LocalObjectReference item) {
        if (this.caCertRefs == null) {
            this.caCertRefs = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertRefs.size()) {
            this._visitables.get((Object)"caCertRefs").add(builder);
            this.caCertRefs.add(builder);
        } else {
            this._visitables.get((Object)"caCertRefs").set(index, builder);
            this.caCertRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCaCertRefs(LocalObjectReference ... items) {
        if (this.caCertRefs == null) {
            this.caCertRefs = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertRefs").add(builder);
            this.caCertRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToV1CaCertRefs(Collection<LocalObjectReference> items) {
        if (this.caCertRefs == null) {
            this.caCertRefs = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertRefs").add(builder);
            this.caCertRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCaCertRefs(LocalObjectReference ... items) {
        if (this.caCertRefs == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertRefs").remove((Object)builder);
            this.caCertRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromV1CaCertRefs(Collection<LocalObjectReference> items) {
        if (this.caCertRefs == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"caCertRefs").remove((Object)builder);
            this.caCertRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromV1CaCertRefs(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.caCertRefs == null) {
            return (A)((Object)this);
        }
        Iterator<LocalObjectReferenceBuilder> each = this.caCertRefs.iterator();
        List visitables = this._visitables.get((Object)"caCertRefs");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalObjectReference> buildCaCertRefs() {
        return this.caCertRefs != null ? BackendTLSPolicyConfigFluent.build(this.caCertRefs) : null;
    }

    public LocalObjectReference buildCaCertRef(int index) {
        return this.caCertRefs.get(index).build();
    }

    public LocalObjectReference buildFirstCaCertRef() {
        return this.caCertRefs.get(0).build();
    }

    public LocalObjectReference buildLastCaCertRef() {
        return this.caCertRefs.get(this.caCertRefs.size() - 1).build();
    }

    public LocalObjectReference buildMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.caCertRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.caCertRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCaCertRefs(List<LocalObjectReference> caCertRefs) {
        if (this.caCertRefs != null) {
            this._visitables.get((Object)"caCertRefs").clear();
        }
        if (caCertRefs != null) {
            this.caCertRefs = new ArrayList();
            for (LocalObjectReference item : caCertRefs) {
                this.addToCaCertRefs(item);
            }
        } else {
            this.caCertRefs = null;
        }
        return (A)((Object)this);
    }

    public A withCaCertRefs(LocalObjectReference ... caCertRefs) {
        if (this.caCertRefs != null) {
            this.caCertRefs.clear();
            this._visitables.remove((Object)"caCertRefs");
        }
        if (caCertRefs != null) {
            for (LocalObjectReference item : caCertRefs) {
                this.addToCaCertRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCaCertRefs() {
        return this.caCertRefs != null && !this.caCertRefs.isEmpty();
    }

    public A addNewCaCertRef(String group, String kind, String name) {
        return this.addToCaCertRefs(new LocalObjectReference(group, kind, name));
    }

    public CaCertRefsNested<A> addNewCaCertRef() {
        return new CaCertRefsNested(-1, null);
    }

    public CaCertRefsNested<A> addNewCaCertRefLike(LocalObjectReference item) {
        return new CaCertRefsNested(-1, item);
    }

    public CaCertRefsNested<A> setNewCaCertRefLike(int index, LocalObjectReference item) {
        return new CaCertRefsNested(index, item);
    }

    public CaCertRefsNested<A> editCaCertRef(int index) {
        if (this.caCertRefs.size() <= index) {
            throw new RuntimeException("Can't edit caCertRefs. Index exceeds size.");
        }
        return this.setNewCaCertRefLike(index, this.buildCaCertRef(index));
    }

    public CaCertRefsNested<A> editFirstCaCertRef() {
        if (this.caCertRefs.size() == 0) {
            throw new RuntimeException("Can't edit first caCertRefs. The list is empty.");
        }
        return this.setNewCaCertRefLike(0, this.buildCaCertRef(0));
    }

    public CaCertRefsNested<A> editLastCaCertRef() {
        int index = this.caCertRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last caCertRefs. The list is empty.");
        }
        return this.setNewCaCertRefLike(index, this.buildCaCertRef(index));
    }

    public CaCertRefsNested<A> editMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.caCertRefs.size(); ++i) {
            if (!predicate.test(this.caCertRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching caCertRefs. No match found.");
        }
        return this.setNewCaCertRefLike(index, this.buildCaCertRef(index));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getWellKnownCACerts() {
        return this.wellKnownCACerts;
    }

    public A withWellKnownCACerts(String wellKnownCACerts) {
        this.wellKnownCACerts = wellKnownCACerts;
        return (A)((Object)this);
    }

    public boolean hasWellKnownCACerts() {
        return this.wellKnownCACerts != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackendTLSPolicyConfigFluent that = (BackendTLSPolicyConfigFluent)((Object)o);
        if (!Objects.equals(this.caCertRefs, that.caCertRefs)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.wellKnownCACerts, that.wellKnownCACerts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.caCertRefs, this.hostname, this.wellKnownCACerts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertRefs != null && !this.caCertRefs.isEmpty()) {
            sb.append("caCertRefs:");
            sb.append(this.caCertRefs + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.wellKnownCACerts != null) {
            sb.append("wellKnownCACerts:");
            sb.append(this.wellKnownCACerts + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaCertRefsNested<N>
    extends LocalObjectReferenceFluent<CaCertRefsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        CaCertRefsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BackendTLSPolicyConfigFluent.this.setToCaCertRefs(this.index, this.builder.build());
        }

        public N endV1CaCertRef() {
            return this.and();
        }
    }
}

