package io.fabric8.kubernetes.api.model.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitedPriorityLevelConfigurationBuilder extends LimitedPriorityLevelConfigurationFluentImpl<LimitedPriorityLevelConfigurationBuilder> implements VisitableBuilder<LimitedPriorityLevelConfiguration,LimitedPriorityLevelConfigurationBuilder>{
  public LimitedPriorityLevelConfigurationBuilder() {
    this(false);
  }
  public LimitedPriorityLevelConfigurationBuilder(Boolean validationEnabled) {
    this(new LimitedPriorityLevelConfiguration(), validationEnabled);
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LimitedPriorityLevelConfiguration(), validationEnabled);
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfigurationFluent<?> fluent,LimitedPriorityLevelConfiguration instance) {
    this(fluent, instance, false);
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfigurationFluent<?> fluent,LimitedPriorityLevelConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
      fluent.withLendablePercent(instance.getLendablePercent());
      fluent.withLimitResponse(instance.getLimitResponse());
      fluent.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfiguration instance) {
    this(instance,false);
  }
  public LimitedPriorityLevelConfigurationBuilder(LimitedPriorityLevelConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
      this.withLendablePercent(instance.getLendablePercent());
      this.withLimitResponse(instance.getLimitResponse());
      this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LimitedPriorityLevelConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public LimitedPriorityLevelConfiguration build() {
    LimitedPriorityLevelConfiguration buildable = new LimitedPriorityLevelConfiguration(fluent.getBorrowingLimitPercent(),fluent.getLendablePercent(),fluent.getLimitResponse(),fluent.getNominalConcurrencyShares());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}