package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationConditionBuilder extends PriorityLevelConfigurationConditionFluentImpl<PriorityLevelConfigurationConditionBuilder> implements VisitableBuilder<PriorityLevelConfigurationCondition,PriorityLevelConfigurationConditionBuilder>{
  public PriorityLevelConfigurationConditionBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationConditionBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfigurationCondition(), validationEnabled);
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfigurationCondition(), validationEnabled);
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationConditionFluent<?> fluent,PriorityLevelConfigurationCondition instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationConditionFluent<?> fluent,PriorityLevelConfigurationCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationCondition instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationConditionBuilder(PriorityLevelConfigurationCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfigurationCondition build() {
    PriorityLevelConfigurationCondition buildable = new PriorityLevelConfigurationCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}