package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyRulesWithSubjectsFluentImpl<A extends PolicyRulesWithSubjectsFluent<A>> extends BaseFluent<A> implements PolicyRulesWithSubjectsFluent<A>{
  public PolicyRulesWithSubjectsFluentImpl() {
  }
  public PolicyRulesWithSubjectsFluentImpl(PolicyRulesWithSubjects instance) {
    this.withNonResourceRules(instance.getNonResourceRules()); 
    this.withResourceRules(instance.getResourceRules()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<NonResourcePolicyRuleBuilder> nonResourceRules = new ArrayList<NonResourcePolicyRuleBuilder>();
  private ArrayList<ResourcePolicyRuleBuilder> resourceRules = new ArrayList<ResourcePolicyRuleBuilder>();
  private ArrayList<SubjectBuilder> subjects = new ArrayList<SubjectBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToNonResourceRules(Integer index,NonResourcePolicyRule item) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourcePolicyRuleBuilder>();}
    NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);_visitables.get("nonResourceRules").add(index >= 0 ? index : _visitables.get("nonResourceRules").size(), builder);this.nonResourceRules.add(index >= 0 ? index : nonResourceRules.size(), builder); return (A)this;
  }
  public A setToNonResourceRules(Integer index,NonResourcePolicyRule item) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourcePolicyRuleBuilder>();}
    NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("nonResourceRules").size()) { _visitables.get("nonResourceRules").add(builder); } else { _visitables.get("nonResourceRules").set(index, builder);}
    if (index < 0 || index >= nonResourceRules.size()) { nonResourceRules.add(builder); } else { nonResourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToNonResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.NonResourcePolicyRule... items) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourcePolicyRuleBuilder>();}
    for (NonResourcePolicyRule item : items) {NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
  }
  public A addAllToNonResourceRules(Collection<NonResourcePolicyRule> items) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourcePolicyRuleBuilder>();}
    for (NonResourcePolicyRule item : items) {NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
  }
  public A removeFromNonResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.NonResourcePolicyRule... items) {
    for (NonResourcePolicyRule item : items) {NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromNonResourceRules(Collection<NonResourcePolicyRule> items) {
    for (NonResourcePolicyRule item : items) {NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNonResourceRules(Predicate<NonResourcePolicyRuleBuilder> predicate) {
    if (nonResourceRules == null) return (A) this;
    final Iterator<NonResourcePolicyRuleBuilder> each = nonResourceRules.iterator();
    final List visitables = _visitables.get("nonResourceRules");
    while (each.hasNext()) {
      NonResourcePolicyRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNonResourceRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NonResourcePolicyRule> getNonResourceRules() {
    return nonResourceRules != null ? build(nonResourceRules) : null;
  }
  public List<NonResourcePolicyRule> buildNonResourceRules() {
    return nonResourceRules != null ? build(nonResourceRules) : null;
  }
  public NonResourcePolicyRule buildNonResourceRule(Integer index) {
    return this.nonResourceRules.get(index).build();
  }
  public NonResourcePolicyRule buildFirstNonResourceRule() {
    return this.nonResourceRules.get(0).build();
  }
  public NonResourcePolicyRule buildLastNonResourceRule() {
    return this.nonResourceRules.get(nonResourceRules.size() - 1).build();
  }
  public NonResourcePolicyRule buildMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
    for (NonResourcePolicyRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
    for (NonResourcePolicyRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceRules(List<NonResourcePolicyRule> nonResourceRules) {
    if (this.nonResourceRules != null) { _visitables.get("nonResourceRules").removeAll(this.nonResourceRules);}
    if (nonResourceRules != null) {this.nonResourceRules = new ArrayList(); for (NonResourcePolicyRule item : nonResourceRules){this.addToNonResourceRules(item);}} else { this.nonResourceRules = null;} return (A) this;
  }
  public A withNonResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.NonResourcePolicyRule... nonResourceRules) {
    if (this.nonResourceRules != null) {this.nonResourceRules.clear();}
    if (nonResourceRules != null) {for (NonResourcePolicyRule item :nonResourceRules){ this.addToNonResourceRules(item);}} return (A) this;
  }
  public Boolean hasNonResourceRules() {
    return nonResourceRules != null && !nonResourceRules.isEmpty();
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> addNewNonResourceRule() {
    return new PolicyRulesWithSubjectsFluentImpl.NonResourceRulesNestedImpl();
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourcePolicyRule item) {
    return new PolicyRulesWithSubjectsFluentImpl.NonResourceRulesNestedImpl(-1, item);
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(Integer index,NonResourcePolicyRule item) {
    return new PolicyRulesWithSubjectsFluentImpl.NonResourceRulesNestedImpl(index, item);
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> editNonResourceRule(Integer index) {
    if (nonResourceRules.size() <= index) throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> editFirstNonResourceRule() {
    if (nonResourceRules.size() == 0) throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
    return setNewNonResourceRuleLike(0, buildNonResourceRule(0));
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> editLastNonResourceRule() {
    int index = nonResourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public PolicyRulesWithSubjectsFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nonResourceRules.size();i++) { 
    if (predicate.test(nonResourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public A addToResourceRules(Integer index,ResourcePolicyRule item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourcePolicyRuleBuilder>();}
    ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);_visitables.get("resourceRules").add(index >= 0 ? index : _visitables.get("resourceRules").size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
  }
  public A setToResourceRules(Integer index,ResourcePolicyRule item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourcePolicyRuleBuilder>();}
    ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceRules").size()) { _visitables.get("resourceRules").add(builder); } else { _visitables.get("resourceRules").set(index, builder);}
    if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ResourcePolicyRule... items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourcePolicyRuleBuilder>();}
    for (ResourcePolicyRule item : items) {ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A addAllToResourceRules(Collection<ResourcePolicyRule> items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourcePolicyRuleBuilder>();}
    for (ResourcePolicyRule item : items) {ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A removeFromResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ResourcePolicyRule... items) {
    for (ResourcePolicyRule item : items) {ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceRules(Collection<ResourcePolicyRule> items) {
    for (ResourcePolicyRule item : items) {ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceRules(Predicate<ResourcePolicyRuleBuilder> predicate) {
    if (resourceRules == null) return (A) this;
    final Iterator<ResourcePolicyRuleBuilder> each = resourceRules.iterator();
    final List visitables = _visitables.get("resourceRules");
    while (each.hasNext()) {
      ResourcePolicyRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourcePolicyRule> getResourceRules() {
    return resourceRules != null ? build(resourceRules) : null;
  }
  public List<ResourcePolicyRule> buildResourceRules() {
    return resourceRules != null ? build(resourceRules) : null;
  }
  public ResourcePolicyRule buildResourceRule(Integer index) {
    return this.resourceRules.get(index).build();
  }
  public ResourcePolicyRule buildFirstResourceRule() {
    return this.resourceRules.get(0).build();
  }
  public ResourcePolicyRule buildLastResourceRule() {
    return this.resourceRules.get(resourceRules.size() - 1).build();
  }
  public ResourcePolicyRule buildMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
    for (ResourcePolicyRuleBuilder item: resourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
    for (ResourcePolicyRuleBuilder item: resourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceRules(List<ResourcePolicyRule> resourceRules) {
    if (this.resourceRules != null) { _visitables.get("resourceRules").removeAll(this.resourceRules);}
    if (resourceRules != null) {this.resourceRules = new ArrayList(); for (ResourcePolicyRule item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
  }
  public A withResourceRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ResourcePolicyRule... resourceRules) {
    if (this.resourceRules != null) {this.resourceRules.clear();}
    if (resourceRules != null) {for (ResourcePolicyRule item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
  }
  public Boolean hasResourceRules() {
    return resourceRules != null && !resourceRules.isEmpty();
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> addNewResourceRule() {
    return new PolicyRulesWithSubjectsFluentImpl.ResourceRulesNestedImpl();
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> addNewResourceRuleLike(ResourcePolicyRule item) {
    return new PolicyRulesWithSubjectsFluentImpl.ResourceRulesNestedImpl(-1, item);
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> setNewResourceRuleLike(Integer index,ResourcePolicyRule item) {
    return new PolicyRulesWithSubjectsFluentImpl.ResourceRulesNestedImpl(index, item);
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> editResourceRule(Integer index) {
    if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> editFirstResourceRule() {
    if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
    return setNewResourceRuleLike(0, buildResourceRule(0));
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> editLastResourceRule() {
    int index = resourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public PolicyRulesWithSubjectsFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceRules.size();i++) { 
    if (predicate.test(resourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public A addToSubjects(Integer index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
  }
  public A setToSubjects(Integer index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
    if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
     return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.Subject... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(Collection<Subject> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.Subject... items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(Collection<Subject> items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<SubjectBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      SubjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Subject> getSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public List<Subject> buildSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public Subject buildSubject(Integer index) {
    return this.subjects.get(index).build();
  }
  public Subject buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public Subject buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(List<Subject> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
    if (subjects != null) {this.subjects = new ArrayList(); for (Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear();}
    if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> addNewSubject() {
    return new PolicyRulesWithSubjectsFluentImpl.SubjectsNestedImpl();
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
    return new PolicyRulesWithSubjectsFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> setNewSubjectLike(Integer index,Subject item) {
    return new PolicyRulesWithSubjectsFluentImpl.SubjectsNestedImpl(index, item);
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> editSubject(Integer index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public PolicyRulesWithSubjectsFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PolicyRulesWithSubjectsFluentImpl that = (PolicyRulesWithSubjectsFluentImpl) o;
    if (nonResourceRules != null ? !nonResourceRules.equals(that.nonResourceRules) :that.nonResourceRules != null) return false;
    if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
    if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nonResourceRules,  resourceRules,  subjects,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nonResourceRules != null && !nonResourceRules.isEmpty()) { sb.append("nonResourceRules:"); sb.append(nonResourceRules + ","); }
    if (resourceRules != null && !resourceRules.isEmpty()) { sb.append("resourceRules:"); sb.append(resourceRules + ","); }
    if (subjects != null && !subjects.isEmpty()) { sb.append("subjects:"); sb.append(subjects + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NonResourceRulesNestedImpl<N> extends NonResourcePolicyRuleFluentImpl<PolicyRulesWithSubjectsFluent.NonResourceRulesNested<N>> implements PolicyRulesWithSubjectsFluent.NonResourceRulesNested<N>,Nested<N>{
    NonResourceRulesNestedImpl(Integer index,NonResourcePolicyRule item) {
      this.index = index;
      this.builder = new NonResourcePolicyRuleBuilder(this, item);
    }
    NonResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new NonResourcePolicyRuleBuilder(this);
    }
    NonResourcePolicyRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) PolicyRulesWithSubjectsFluentImpl.this.setToNonResourceRules(index,builder.build());
    }
    public N endNonResourceRule() {
      return and();
    }
    
  }
  class ResourceRulesNestedImpl<N> extends ResourcePolicyRuleFluentImpl<PolicyRulesWithSubjectsFluent.ResourceRulesNested<N>> implements PolicyRulesWithSubjectsFluent.ResourceRulesNested<N>,Nested<N>{
    ResourceRulesNestedImpl(Integer index,ResourcePolicyRule item) {
      this.index = index;
      this.builder = new ResourcePolicyRuleBuilder(this, item);
    }
    ResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new ResourcePolicyRuleBuilder(this);
    }
    ResourcePolicyRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) PolicyRulesWithSubjectsFluentImpl.this.setToResourceRules(index,builder.build());
    }
    public N endResourceRule() {
      return and();
    }
    
  }
  class SubjectsNestedImpl<N> extends SubjectFluentImpl<PolicyRulesWithSubjectsFluent.SubjectsNested<N>> implements PolicyRulesWithSubjectsFluent.SubjectsNested<N>,Nested<N>{
    SubjectsNestedImpl(Integer index,Subject item) {
      this.index = index;
      this.builder = new SubjectBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new SubjectBuilder(this);
    }
    SubjectBuilder builder;
    Integer index;
    public N and() {
      return (N) PolicyRulesWithSubjectsFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}