package io.fabric8.kubernetes.api.model.flowcontrol.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FlowSchemaBuilder extends FlowSchemaFluent<FlowSchemaBuilder> implements VisitableBuilder<FlowSchema,FlowSchemaBuilder>{
  public FlowSchemaBuilder() {
    this(new FlowSchema());
  }
  
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent) {
    this(fluent, new FlowSchema());
  }
  
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent,FlowSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FlowSchemaBuilder(FlowSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FlowSchemaFluent<?> fluent;
  
  public FlowSchema build() {
    FlowSchema buildable = new FlowSchema(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}