package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServerStorageVersionBuilder extends ServerStorageVersionFluent<ServerStorageVersionBuilder> implements VisitableBuilder<ServerStorageVersion,ServerStorageVersionBuilder>{
  public ServerStorageVersionBuilder() {
    this(new ServerStorageVersion());
  }
  
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent) {
    this(fluent, new ServerStorageVersion());
  }
  
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent,ServerStorageVersion instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServerStorageVersionBuilder(ServerStorageVersion instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServerStorageVersionFluent<?> fluent;
  
  public ServerStorageVersion build() {
    ServerStorageVersion buildable = new ServerStorageVersion(fluent.getApiServerID(),fluent.getDecodableVersions(),fluent.getEncodingVersion(),fluent.getServedVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}