package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkPolicyPeerFluent<A extends NetworkPolicyPeerFluent<A>> extends BaseFluent<A>{
  public NetworkPolicyPeerFluent() {
  }
  
  public NetworkPolicyPeerFluent(NetworkPolicyPeer instance) {
    this.copyInstance(instance);
  }
  private IPBlockBuilder ipBlock;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder podSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkPolicyPeer instance) {
    instance = (instance != null ? instance : new NetworkPolicyPeer());
  
    if (instance != null) {
        this.withIpBlock(instance.getIpBlock());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
        this.withIpBlock(instance.getIpBlock());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public IPBlock buildIpBlock() {
    return this.ipBlock!=null ?this.ipBlock.build():null;
  }
  
  public A withIpBlock(IPBlock ipBlock) {
    _visitables.get("ipBlock").remove(this.ipBlock);
    if (ipBlock!=null){ this.ipBlock= new IPBlockBuilder(ipBlock); _visitables.get("ipBlock").add(this.ipBlock);} else { this.ipBlock = null; _visitables.get("ipBlock").remove(this.ipBlock); } return (A) this;
  }
  
  public boolean hasIpBlock() {
    return this.ipBlock != null;
  }
  
  public IpBlockNested<A> withNewIpBlock() {
    return new IpBlockNested(null);
  }
  
  public IpBlockNested<A> withNewIpBlockLike(IPBlock item) {
    return new IpBlockNested(item);
  }
  
  public IpBlockNested<A> editIpBlock() {
    return withNewIpBlockLike(java.util.Optional.ofNullable(buildIpBlock()).orElse(null));
  }
  
  public IpBlockNested<A> editOrNewIpBlock() {
    return withNewIpBlockLike(java.util.Optional.ofNullable(buildIpBlock()).orElse(new IPBlockBuilder().build()));
  }
  
  public IpBlockNested<A> editOrNewIpBlockLike(IPBlock item) {
    return withNewIpBlockLike(java.util.Optional.ofNullable(buildIpBlock()).orElse(item));
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public LabelSelector buildPodSelector() {
    return this.podSelector!=null ?this.podSelector.build():null;
  }
  
  public A withPodSelector(LabelSelector podSelector) {
    _visitables.get("podSelector").remove(this.podSelector);
    if (podSelector!=null){ this.podSelector= new LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} else { this.podSelector = null; _visitables.get("podSelector").remove(this.podSelector); } return (A) this;
  }
  
  public boolean hasPodSelector() {
    return this.podSelector != null;
  }
  
  public PodSelectorNested<A> withNewPodSelector() {
    return new PodSelectorNested(null);
  }
  
  public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
    return new PodSelectorNested(item);
  }
  
  public PodSelectorNested<A> editPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(null));
  }
  
  public PodSelectorNested<A> editOrNewPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyPeerFluent that = (NetworkPolicyPeerFluent) o;
    if (!java.util.Objects.equals(ipBlock, that.ipBlock)) return false;
  
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
  
    if (!java.util.Objects.equals(podSelector, that.podSelector)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ipBlock,  namespaceSelector,  podSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipBlock != null) { sb.append("ipBlock:"); sb.append(ipBlock + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (podSelector != null) { sb.append("podSelector:"); sb.append(podSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IpBlockNested<N> extends IPBlockFluent<IpBlockNested<N>> implements Nested<N>{
    IpBlockNested(IPBlock item) {
      this.builder = new IPBlockBuilder(this, item);
    }
    IPBlockBuilder builder;
    
    public N and() {
      return (N) NetworkPolicyPeerFluent.this.withIpBlock(builder.build());
    }
    
    public N endIpBlock() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) NetworkPolicyPeerFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class PodSelectorNested<N> extends LabelSelectorFluent<PodSelectorNested<N>> implements Nested<N>{
    PodSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) NetworkPolicyPeerFluent.this.withPodSelector(builder.build());
    }
    
    public N endPodSelector() {
      return and();
    }
    
  
  }

}