package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressBackendFluent<A extends IngressBackendFluent<A>> extends BaseFluent<A>{
  public IngressBackendFluent() {
  }
  
  public IngressBackendFluent(IngressBackend instance) {
    this.copyInstance(instance);
  }
  private TypedLocalObjectReference resource;
  private String serviceName;
  private IntOrStringBuilder servicePort;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressBackend instance) {
    instance = (instance != null ? instance : new IngressBackend());
  
    if (instance != null) {
        this.withResource(instance.getResource());
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.withResource(instance.getResource());
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public TypedLocalObjectReference getResource() {
    return this.resource;
  }
  
  public A withResource(TypedLocalObjectReference resource) {
    this.resource=resource; return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public A withNewResource(String apiGroup,String kind,String name) {
    return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  
  public String getServiceName() {
    return this.serviceName;
  }
  
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  
  public boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  public IntOrString buildServicePort() {
    return this.servicePort!=null ?this.servicePort.build():null;
  }
  
  public A withServicePort(IntOrString servicePort) {
    _visitables.get("servicePort").remove(this.servicePort);
    if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.get("servicePort").add(this.servicePort);} else { this.servicePort = null; _visitables.get("servicePort").remove(this.servicePort); } return (A) this;
  }
  
  public boolean hasServicePort() {
    return this.servicePort != null;
  }
  
  public A withNewServicePort(Object value) {
    return (A)withServicePort(new IntOrString(value));
  }
  
  public ServicePortNested<A> withNewServicePort() {
    return new ServicePortNested(null);
  }
  
  public ServicePortNested<A> withNewServicePortLike(IntOrString item) {
    return new ServicePortNested(item);
  }
  
  public ServicePortNested<A> editServicePort() {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(null));
  }
  
  public ServicePortNested<A> editOrNewServicePort() {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(new IntOrStringBuilder().build()));
  }
  
  public ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
    return withNewServicePortLike(java.util.Optional.ofNullable(buildServicePort()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressBackendFluent that = (IngressBackendFluent) o;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
  
    if (!java.util.Objects.equals(serviceName, that.serviceName)) return false;
  
    if (!java.util.Objects.equals(servicePort, that.servicePort)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(resource,  serviceName,  servicePort,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (servicePort != null) { sb.append("servicePort:"); sb.append(servicePort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServicePortNested<N> extends IntOrStringFluent<ServicePortNested<N>> implements Nested<N>{
    ServicePortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) IngressBackendFluent.this.withServicePort(builder.build());
    }
    
    public N endServicePort() {
      return and();
    }
    
  
  }

}