package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetListBuilder extends DaemonSetListFluent<DaemonSetListBuilder> implements VisitableBuilder<DaemonSetList,DaemonSetListBuilder>{
  public DaemonSetListBuilder() {
    this(false);
  }
  public DaemonSetListBuilder(Boolean validationEnabled) {
    this(new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,DaemonSetList instance) {
    this(fluent, instance, false);
  }
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,DaemonSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DaemonSetList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetListBuilder(DaemonSetList instance) {
    this(instance,false);
  }
  public DaemonSetListBuilder(DaemonSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DaemonSetList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonSetListFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSetList build() {
    DaemonSetList buildable = new DaemonSetList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}