package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressLoadBalancerIngressBuilder extends IngressLoadBalancerIngressFluent<IngressLoadBalancerIngressBuilder> implements VisitableBuilder<IngressLoadBalancerIngress,IngressLoadBalancerIngressBuilder>{
  public IngressLoadBalancerIngressBuilder() {
    this(false);
  }
  public IngressLoadBalancerIngressBuilder(Boolean validationEnabled) {
    this(new IngressLoadBalancerIngress(), validationEnabled);
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressLoadBalancerIngress(), validationEnabled);
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngressFluent<?> fluent,IngressLoadBalancerIngress instance) {
    this(fluent, instance, false);
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngressFluent<?> fluent,IngressLoadBalancerIngress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressLoadBalancerIngress());

    if (instance != null) {
      fluent.withHostname(instance.getHostname());
      fluent.withIp(instance.getIp());
      fluent.withPorts(instance.getPorts());
      fluent.withHostname(instance.getHostname());
      fluent.withIp(instance.getIp());
      fluent.withPorts(instance.getPorts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngress instance) {
    this(instance,false);
  }
  public IngressLoadBalancerIngressBuilder(IngressLoadBalancerIngress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressLoadBalancerIngress());

    if (instance != null) {
      this.withHostname(instance.getHostname());
      this.withIp(instance.getIp());
      this.withPorts(instance.getPorts());
      this.withHostname(instance.getHostname());
      this.withIp(instance.getIp());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressLoadBalancerIngressFluent<?> fluent;
  Boolean validationEnabled;
  public IngressLoadBalancerIngress build() {
    IngressLoadBalancerIngress buildable = new IngressLoadBalancerIngress(fluent.getHostname(),fluent.getIp(),fluent.buildPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}