package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollbackConfigBuilder extends RollbackConfigFluentImpl<RollbackConfigBuilder> implements VisitableBuilder<RollbackConfig,RollbackConfigBuilder>{
  public RollbackConfigBuilder() {
    this(false);
  }
  public RollbackConfigBuilder(Boolean validationEnabled) {
    this(new RollbackConfig(), validationEnabled);
  }
  public RollbackConfigBuilder(RollbackConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RollbackConfig(), validationEnabled);
  }
  public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance) {
    this(fluent, instance, false);
  }
  public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRevision(instance.getRevision()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RollbackConfigBuilder(RollbackConfig instance) {
    this(instance,false);
  }
  public RollbackConfigBuilder(RollbackConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RollbackConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RollbackConfig build() {
    RollbackConfig buildable = new RollbackConfig(fluent.getRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}