package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkPolicyEgressRuleFluentImpl<A extends NetworkPolicyEgressRuleFluent<A>> extends BaseFluent<A> implements NetworkPolicyEgressRuleFluent<A>{
  public NetworkPolicyEgressRuleFluentImpl() {
  }
  public NetworkPolicyEgressRuleFluentImpl(NetworkPolicyEgressRule instance) {
    this.withPorts(instance.getPorts()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<NetworkPolicyPortBuilder> ports = new ArrayList<NetworkPolicyPortBuilder>();
  private ArrayList<NetworkPolicyPeerBuilder> to = new ArrayList<NetworkPolicyPeerBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToPorts(Integer index,NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(Integer index,NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPort... items) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<NetworkPolicyPort> items) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPort... items) {
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<NetworkPolicyPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      NetworkPolicyPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NetworkPolicyPort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public List<NetworkPolicyPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public NetworkPolicyPort buildPort(Integer index) {
    return this.ports.get(index).build();
  }
  public NetworkPolicyPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public NetworkPolicyPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    for (NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    for (NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<NetworkPolicyPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new ArrayList(); for (NetworkPolicyPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (NetworkPolicyPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPort() {
    return new NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl();
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
    return new NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl(-1, item);
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> setNewPortLike(Integer index,NetworkPolicyPort item) {
    return new NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl(index, item);
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> editPort(Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToTo(Integer index,NetworkPolicyPeer item) {
    if (this.to == null) {this.to = new ArrayList<NetworkPolicyPeerBuilder>();}
    NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("to").add(index >= 0 ? index : _visitables.get("to").size(), builder);this.to.add(index >= 0 ? index : to.size(), builder); return (A)this;
  }
  public A setToTo(Integer index,NetworkPolicyPeer item) {
    if (this.to == null) {this.to = new ArrayList<NetworkPolicyPeerBuilder>();}
    NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
    if (index < 0 || index >= _visitables.get("to").size()) { _visitables.get("to").add(builder); } else { _visitables.get("to").set(index, builder);}
    if (index < 0 || index >= to.size()) { to.add(builder); } else { to.set(index, builder);}
     return (A)this;
  }
  public A addToTo(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer... items) {
    if (this.to == null) {this.to = new ArrayList<NetworkPolicyPeerBuilder>();}
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  public A addAllToTo(Collection<NetworkPolicyPeer> items) {
    if (this.to == null) {this.to = new ArrayList<NetworkPolicyPeerBuilder>();}
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  public A removeFromTo(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer... items) {
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
  }
  public A removeAllFromTo(Collection<NetworkPolicyPeer> items) {
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
    if (to == null) return (A) this;
    final Iterator<NetworkPolicyPeerBuilder> each = to.iterator();
    final List visitables = _visitables.get("to");
    while (each.hasNext()) {
      NetworkPolicyPeerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NetworkPolicyPeer> getTo() {
    return to != null ? build(to) : null;
  }
  public List<NetworkPolicyPeer> buildTo() {
    return to != null ? build(to) : null;
  }
  public NetworkPolicyPeer buildTo(Integer index) {
    return this.to.get(index).build();
  }
  public NetworkPolicyPeer buildFirstTo() {
    return this.to.get(0).build();
  }
  public NetworkPolicyPeer buildLastTo() {
    return this.to.get(to.size() - 1).build();
  }
  public NetworkPolicyPeer buildMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
    for (NetworkPolicyPeerBuilder item: to) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
    for (NetworkPolicyPeerBuilder item: to) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTo(List<NetworkPolicyPeer> to) {
    if (this.to != null) { _visitables.get("to").removeAll(this.to);}
    if (to != null) {this.to = new ArrayList(); for (NetworkPolicyPeer item : to){this.addToTo(item);}} else { this.to = null;} return (A) this;
  }
  public A withTo(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer... to) {
    if (this.to != null) {this.to.clear();}
    if (to != null) {for (NetworkPolicyPeer item :to){ this.addToTo(item);}} return (A) this;
  }
  public Boolean hasTo() {
    return to != null && !to.isEmpty();
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> addNewTo() {
    return new NetworkPolicyEgressRuleFluentImpl.ToNestedImpl();
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> addNewToLike(NetworkPolicyPeer item) {
    return new NetworkPolicyEgressRuleFluentImpl.ToNestedImpl(-1, item);
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> setNewToLike(Integer index,NetworkPolicyPeer item) {
    return new NetworkPolicyEgressRuleFluentImpl.ToNestedImpl(index, item);
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> editTo(Integer index) {
    if (to.size() <= index) throw new RuntimeException("Can't edit to. Index exceeds size.");
    return setNewToLike(index, buildTo(index));
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> editFirstTo() {
    if (to.size() == 0) throw new RuntimeException("Can't edit first to. The list is empty.");
    return setNewToLike(0, buildTo(0));
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> editLastTo() {
    int index = to.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last to. The list is empty.");
    return setNewToLike(index, buildTo(index));
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> editMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<to.size();i++) { 
    if (predicate.test(to.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching to. No match found.");
    return setNewToLike(index, buildTo(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkPolicyEgressRuleFluentImpl that = (NetworkPolicyEgressRuleFluentImpl) o;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ports,  to,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (to != null && !to.isEmpty()) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PortsNestedImpl<N> extends NetworkPolicyPortFluentImpl<NetworkPolicyEgressRuleFluent.PortsNested<N>> implements NetworkPolicyEgressRuleFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(Integer index,NetworkPolicyPort item) {
      this.index = index;
      this.builder = new NetworkPolicyPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new NetworkPolicyPortBuilder(this);
    }
    NetworkPolicyPortBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkPolicyEgressRuleFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends NetworkPolicyPeerFluentImpl<NetworkPolicyEgressRuleFluent.ToNested<N>> implements NetworkPolicyEgressRuleFluent.ToNested<N>,Nested<N>{
    ToNestedImpl(Integer index,NetworkPolicyPeer item) {
      this.index = index;
      this.builder = new NetworkPolicyPeerBuilder(this, item);
    }
    ToNestedImpl() {
      this.index = -1;
      this.builder = new NetworkPolicyPeerBuilder(this);
    }
    NetworkPolicyPeerBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkPolicyEgressRuleFluentImpl.this.setToTo(index,builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}