package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentRollbackBuilder extends DeploymentRollbackFluent<DeploymentRollbackBuilder> implements VisitableBuilder<DeploymentRollback,DeploymentRollbackBuilder>{
  public DeploymentRollbackBuilder() {
    this(new DeploymentRollback());
  }
  
  public DeploymentRollbackBuilder(DeploymentRollbackFluent<?> fluent) {
    this(fluent, new DeploymentRollback());
  }
  
  public DeploymentRollbackBuilder(DeploymentRollbackFluent<?> fluent,DeploymentRollback instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentRollbackBuilder(DeploymentRollback instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentRollbackFluent<?> fluent;
  
  public DeploymentRollback build() {
    DeploymentRollback buildable = new DeploymentRollback(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.buildRollbackTo(),fluent.getUpdatedAnnotations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}