package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkPolicySpecBuilder extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec,io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecBuilder>{
  public NetworkPolicySpecBuilder() {
    this(false);
  }
  public NetworkPolicySpecBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkPolicySpec(), validationEnabled);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicySpec(), validationEnabled);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEgress(instance.getEgress()); 
    fluent.withIngress(instance.getIngress()); 
    fluent.withPodSelector(instance.getPodSelector()); 
    fluent.withPolicyTypes(instance.getPolicyTypes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance) {
    this(instance,false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEgress(instance.getEgress()); 
    this.withIngress(instance.getIngress()); 
    this.withPodSelector(instance.getPodSelector()); 
    this.withPolicyTypes(instance.getPolicyTypes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec build() {
    NetworkPolicySpec buildable = new NetworkPolicySpec(fluent.getEgress(),fluent.getIngress(),fluent.getPodSelector(),fluent.getPolicyTypes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicySpecBuilder that = (NetworkPolicySpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}