package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;

public class IngressStatusFluentImpl<A extends IngressStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressStatusFluent<A> {

    private LoadBalancerStatus loadBalancer;

    public IngressStatusFluentImpl() { 
    }


    public IngressStatusFluentImpl(IngressStatus instance) { 
        this.withLoadBalancer(instance.getLoadBalancer()); 
    }


    public LoadBalancerStatus getLoadBalancer() {
        return this.loadBalancer;
    }

    public A withLoadBalancer(LoadBalancerStatus loadBalancer) {
        this.loadBalancer=loadBalancer; return (A) this;
    }

    public Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressStatusFluentImpl that = (IngressStatusFluentImpl) o;
        if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(loadBalancer,  super.hashCode());
    }

}
