package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class EventFluentImpl<A extends io.fabric8.kubernetes.api.model.events.v1.EventFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.events.v1.EventFluent<A>{
  public EventFluentImpl() {
  }
  public EventFluentImpl(io.fabric8.kubernetes.api.model.events.v1.Event instance) {
    this.withAction(instance.getAction()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDeprecatedCount(instance.getDeprecatedCount()); 
    this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp()); 
    this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp()); 
    this.withDeprecatedSource(instance.getDeprecatedSource()); 
    this.withEventTime(instance.getEventTime()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNote(instance.getNote()); 
    this.withReason(instance.getReason()); 
    this.withRegarding(instance.getRegarding()); 
    this.withRelated(instance.getRelated()); 
    this.withReportingController(instance.getReportingController()); 
    this.withReportingInstance(instance.getReportingInstance()); 
    this.withSeries(instance.getSeries()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String action;
  private java.lang.String apiVersion;
  private java.lang.Integer deprecatedCount;
  private java.lang.String deprecatedFirstTimestamp;
  private java.lang.String deprecatedLastTimestamp;
  private io.fabric8.kubernetes.api.model.EventSource deprecatedSource;
  private io.fabric8.kubernetes.api.model.MicroTime eventTime;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.lang.String note;
  private java.lang.String reason;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder regarding;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder related;
  private java.lang.String reportingController;
  private java.lang.String reportingInstance;
  private io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder series;
  private java.lang.String type;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getAction() {
    return this.action;
  }
  public A withAction(java.lang.String action) {
    this.action=action; return (A) this;
  }
  public java.lang.Boolean hasAction() {
    return this.action != null;
  }
  
  /**
   * Method is deprecated. use withAction instead.
   */
  @java.lang.Deprecated
  public A withNewAction(java.lang.String arg0) {
    return (A)withAction(new String(arg0));
  }
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.Integer getDeprecatedCount() {
    return this.deprecatedCount;
  }
  public A withDeprecatedCount(java.lang.Integer deprecatedCount) {
    this.deprecatedCount=deprecatedCount; return (A) this;
  }
  public java.lang.Boolean hasDeprecatedCount() {
    return this.deprecatedCount != null;
  }
  public java.lang.String getDeprecatedFirstTimestamp() {
    return this.deprecatedFirstTimestamp;
  }
  public A withDeprecatedFirstTimestamp(java.lang.String deprecatedFirstTimestamp) {
    this.deprecatedFirstTimestamp=deprecatedFirstTimestamp; return (A) this;
  }
  public java.lang.Boolean hasDeprecatedFirstTimestamp() {
    return this.deprecatedFirstTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withDeprecatedFirstTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewDeprecatedFirstTimestamp(java.lang.String arg0) {
    return (A)withDeprecatedFirstTimestamp(new String(arg0));
  }
  public java.lang.String getDeprecatedLastTimestamp() {
    return this.deprecatedLastTimestamp;
  }
  public A withDeprecatedLastTimestamp(java.lang.String deprecatedLastTimestamp) {
    this.deprecatedLastTimestamp=deprecatedLastTimestamp; return (A) this;
  }
  public java.lang.Boolean hasDeprecatedLastTimestamp() {
    return this.deprecatedLastTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withDeprecatedLastTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewDeprecatedLastTimestamp(java.lang.String arg0) {
    return (A)withDeprecatedLastTimestamp(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.EventSource getDeprecatedSource() {
    return this.deprecatedSource;
  }
  public A withDeprecatedSource(io.fabric8.kubernetes.api.model.EventSource deprecatedSource) {
    this.deprecatedSource=deprecatedSource; return (A) this;
  }
  public java.lang.Boolean hasDeprecatedSource() {
    return this.deprecatedSource != null;
  }
  public A withNewDeprecatedSource(java.lang.String component,java.lang.String host) {
    return (A)withDeprecatedSource(new EventSource(component, host));
  }
  public io.fabric8.kubernetes.api.model.MicroTime getEventTime() {
    return this.eventTime;
  }
  public A withEventTime(io.fabric8.kubernetes.api.model.MicroTime eventTime) {
    this.eventTime=eventTime; return (A) this;
  }
  public java.lang.Boolean hasEventTime() {
    return this.eventTime != null;
  }
  public A withNewEventTime(java.lang.String time) {
    return (A)withEventTime(new MicroTime(time));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.String getNote() {
    return this.note;
  }
  public A withNote(java.lang.String note) {
    this.note=note; return (A) this;
  }
  public java.lang.Boolean hasNote() {
    return this.note != null;
  }
  
  /**
   * Method is deprecated. use withNote instead.
   */
  @java.lang.Deprecated
  public A withNewNote(java.lang.String arg0) {
    return (A)withNote(new String(arg0));
  }
  public java.lang.String getReason() {
    return this.reason;
  }
  public A withReason(java.lang.String reason) {
    this.reason=reason; return (A) this;
  }
  public java.lang.Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * Method is deprecated. use withReason instead.
   */
  @java.lang.Deprecated
  public A withNewReason(java.lang.String arg0) {
    return (A)withReason(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildRegarding instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getRegarding() {
    return this.regarding!=null?this.regarding.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildRegarding() {
    return this.regarding!=null?this.regarding.build():null;
  }
  public A withRegarding(io.fabric8.kubernetes.api.model.ObjectReference regarding) {
    _visitables.get("regarding").remove(this.regarding);
    if (regarding!=null){ this.regarding= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(regarding); _visitables.get("regarding").add(this.regarding);} return (A) this;
  }
  public java.lang.Boolean hasRegarding() {
    return this.regarding != null;
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<A> withNewRegarding() {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.RegardingNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<A> withNewRegardingLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.RegardingNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<A> editRegarding() {
    return withNewRegardingLike(getRegarding());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<A> editOrNewRegarding() {
    return withNewRegardingLike(getRegarding() != null ? getRegarding(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<A> editOrNewRegardingLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewRegardingLike(getRegarding() != null ? getRegarding(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRelated instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getRelated() {
    return this.related!=null?this.related.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildRelated() {
    return this.related!=null?this.related.build():null;
  }
  public A withRelated(io.fabric8.kubernetes.api.model.ObjectReference related) {
    _visitables.get("related").remove(this.related);
    if (related!=null){ this.related= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(related); _visitables.get("related").add(this.related);} return (A) this;
  }
  public java.lang.Boolean hasRelated() {
    return this.related != null;
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<A> withNewRelated() {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.RelatedNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<A> withNewRelatedLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.RelatedNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<A> editRelated() {
    return withNewRelatedLike(getRelated());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<A> editOrNewRelated() {
    return withNewRelatedLike(getRelated() != null ? getRelated(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<A> editOrNewRelatedLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewRelatedLike(getRelated() != null ? getRelated(): item);
  }
  public java.lang.String getReportingController() {
    return this.reportingController;
  }
  public A withReportingController(java.lang.String reportingController) {
    this.reportingController=reportingController; return (A) this;
  }
  public java.lang.Boolean hasReportingController() {
    return this.reportingController != null;
  }
  
  /**
   * Method is deprecated. use withReportingController instead.
   */
  @java.lang.Deprecated
  public A withNewReportingController(java.lang.String arg0) {
    return (A)withReportingController(new String(arg0));
  }
  public java.lang.String getReportingInstance() {
    return this.reportingInstance;
  }
  public A withReportingInstance(java.lang.String reportingInstance) {
    this.reportingInstance=reportingInstance; return (A) this;
  }
  public java.lang.Boolean hasReportingInstance() {
    return this.reportingInstance != null;
  }
  
  /**
   * Method is deprecated. use withReportingInstance instead.
   */
  @java.lang.Deprecated
  public A withNewReportingInstance(java.lang.String arg0) {
    return (A)withReportingInstance(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildSeries instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.events.v1.EventSeries getSeries() {
    return this.series!=null?this.series.build():null;
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventSeries buildSeries() {
    return this.series!=null?this.series.build():null;
  }
  public A withSeries(io.fabric8.kubernetes.api.model.events.v1.EventSeries series) {
    _visitables.get("series").remove(this.series);
    if (series!=null){ this.series= new io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder(series); _visitables.get("series").add(this.series);} return (A) this;
  }
  public java.lang.Boolean hasSeries() {
    return this.series != null;
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<A> withNewSeries() {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.SeriesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<A> withNewSeriesLike(io.fabric8.kubernetes.api.model.events.v1.EventSeries item) {
    return new io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl.SeriesNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<A> editSeries() {
    return withNewSeriesLike(getSeries());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<A> editOrNewSeries() {
    return withNewSeriesLike(getSeries() != null ? getSeries(): new io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<A> editOrNewSeriesLike(io.fabric8.kubernetes.api.model.events.v1.EventSeries item) {
    return withNewSeriesLike(getSeries() != null ? getSeries(): item);
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * Method is deprecated. use withType instead.
   */
  @java.lang.Deprecated
  public A withNewType(java.lang.String arg0) {
    return (A)withType(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventFluentImpl that = (EventFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (deprecatedCount != null ? !deprecatedCount.equals(that.deprecatedCount) :that.deprecatedCount != null) return false;
    if (deprecatedFirstTimestamp != null ? !deprecatedFirstTimestamp.equals(that.deprecatedFirstTimestamp) :that.deprecatedFirstTimestamp != null) return false;
    if (deprecatedLastTimestamp != null ? !deprecatedLastTimestamp.equals(that.deprecatedLastTimestamp) :that.deprecatedLastTimestamp != null) return false;
    if (deprecatedSource != null ? !deprecatedSource.equals(that.deprecatedSource) :that.deprecatedSource != null) return false;
    if (eventTime != null ? !eventTime.equals(that.eventTime) :that.eventTime != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (note != null ? !note.equals(that.note) :that.note != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (regarding != null ? !regarding.equals(that.regarding) :that.regarding != null) return false;
    if (related != null ? !related.equals(that.related) :that.related != null) return false;
    if (reportingController != null ? !reportingController.equals(that.reportingController) :that.reportingController != null) return false;
    if (reportingInstance != null ? !reportingInstance.equals(that.reportingInstance) :that.reportingInstance != null) return false;
    if (series != null ? !series.equals(that.series) :that.series != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  apiVersion,  deprecatedCount,  deprecatedFirstTimestamp,  deprecatedLastTimestamp,  deprecatedSource,  eventTime,  kind,  metadata,  note,  reason,  regarding,  related,  reportingController,  reportingInstance,  series,  type,  additionalProperties,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.events.v1.EventFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class RegardingNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<N>> implements io.fabric8.kubernetes.api.model.events.v1.EventFluent.RegardingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RegardingNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    RegardingNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withRegarding(builder.build());
    }
    public N endRegarding() {
      return and();
    }
    
  }
  public class RelatedNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<N>> implements io.fabric8.kubernetes.api.model.events.v1.EventFluent.RelatedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelatedNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    RelatedNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withRelated(builder.build());
    }
    public N endRelated() {
      return and();
    }
    
  }
  public class SeriesNestedImpl<N> extends io.fabric8.kubernetes.api.model.events.v1.EventSeriesFluentImpl<io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<N>> implements io.fabric8.kubernetes.api.model.events.v1.EventFluent.SeriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SeriesNestedImpl(io.fabric8.kubernetes.api.model.events.v1.EventSeries item) {
      this.builder = new io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder(this, item);
    }
    SeriesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder(this);
    }
    io.fabric8.kubernetes.api.model.events.v1.EventSeriesBuilder builder;
    public N and() {
      return (N) EventFluentImpl.this.withSeries(builder.build());
    }
    public N endSeries() {
      return and();
    }
    
  }
  
}