package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ForNodeBuilder extends ForNodeFluent<ForNodeBuilder> implements VisitableBuilder<ForNode,ForNodeBuilder>{
  public ForNodeBuilder() {
    this(new ForNode());
  }
  
  public ForNodeBuilder(ForNodeFluent<?> fluent) {
    this(fluent, new ForNode());
  }
  
  public ForNodeBuilder(ForNodeFluent<?> fluent,ForNode instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ForNodeBuilder(ForNode instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ForNodeFluent<?> fluent;
  
  public ForNode build() {
    ForNode buildable = new ForNode(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}